/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class Permissions {
    static final Splitter PERMISSION_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    static final Joiner PERMISSION_JOINER = Joiner.on((String)",").skipNulls();
    private static final Logger logger = LoggerFactory.getLogger(Permissions.class);

    static Iterable<String> splitPrincipals(String principals) {
        if (principals == null) {
            return Lists.newArrayList();
        }
        return PERMISSION_SPLITTER.split((CharSequence)principals);
    }

    static Iterable<Integer> splitRoles(String roles) {
        return Iterables.transform(Permissions.splitPrincipals(roles), (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.valueOf(input);
            }
        });
    }

    static String joinRoles(Iterable<Integer> roles) {
        return PERMISSION_JOINER.join(roles);
    }

    static String joinRoles(Integer ... roles) {
        return PERMISSION_JOINER.join((Object[])roles);
    }

    static Iterable<Integer> rolesToIds(Iterable<Role> roles) {
        return Iterables.transform(roles, (Function)new Function<Role, Integer>(){

            public Integer apply(Role input) {
                return input.getId();
            }
        });
    }

    public static ImmutableMap<Integer, Role> buildLookup(List<Role> roles) {
        return Maps.uniqueIndex(roles, (Function)new Function<Role, Integer>(){

            public Integer apply(Role input) {
                return input.getId();
            }
        });
    }

    static List<String> getFullTreeAsSeparateNodesInChildToRootOrder(String onConfigurationItem) {
        ArrayList list = Lists.newArrayList();
        int index = onConfigurationItem.indexOf(47);
        while (index > -1) {
            list.add(onConfigurationItem.substring(0, index));
            index = onConfigurationItem.indexOf(47, index + 1);
        }
        list.add(onConfigurationItem);
        Collections.reverse(list);
        logger.debug("Split off tree: {} to {}", (Object)onConfigurationItem, (Object)list);
        return list;
    }

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static String getAuthenticatedUserName() {
        return Permissions.getAuthentication() != null ? Permissions.getAuthentication().getName() : null;
    }

    public static void clearSecurityContext() {
        SecurityContextHolder.clearContext();
    }

    public static Collection<String> authenticationToPrincipals(Authentication authentication) {
        String name = authentication.getName();
        Iterable<String> authorities = Permissions.getAuthorities(authentication);
        HashSet allPrincipals = Sets.newHashSet(authorities);
        allPrincipals.add(name);
        logger.trace("All principals for user [{}] are: {}", (Object)authentication.getName(), (Object)allPrincipals);
        return allPrincipals;
    }

    private static Iterable<String> getAuthorities(Authentication authentication) {
        return Iterables.transform((Iterable)authentication.getAuthorities(), (Function)new Function<GrantedAuthority, String>(){

            public String apply(GrantedAuthority input) {
                return input.getAuthority();
            }
        });
    }

    static Node readSecurable(String securable, Session session) throws RepositoryException {
        Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(securable));
        Permissions.checkSecurable(node);
        return node;
    }

    static void checkSecurable(Node node) throws RepositoryException {
        String type = node.getProperty("$configuration.item.type").getString();
        Checks.checkArgument(Permissions.isSecurable(node), "Cannot set permission on [%s] because it is not a Directory or Root [%s]", JcrPathHelper.getIdFromAbsolutePath(node.getPath()), type);
    }

    static boolean isSecurable(Node node) throws RepositoryException {
        String type = node.getProperty("$configuration.item.type").getString();
        return Type.valueOf((String)type).isSubTypeOf(Type.valueOf(Securable.class));
    }

    static Map<String, String> readPermissionMap(Node s) throws RepositoryException {
        Map<Object, Object> permissions = Maps.newHashMap();
        if (s.hasProperty("securityPermissions")) {
            Property securityPermissions = s.getProperty("securityPermissions");
            permissions = JcrUtils.readMap(securityPermissions);
        }
        return permissions;
    }

    static void writePermissionMap(Node s, Map<String, String> permissions) throws RepositoryException {
        JcrUtils.writeMap(s, "securityPermissions", permissions);
    }

    public static Collection<Permission> isApplicableTo(Collection<Permission> values, final String id) {
        return Collections2.filter(values, (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission input) {
                return !input.isApplicableTo(id);
            }
        });
    }
}

