/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.ReadPermissionHandler;

public enum Permission {
    LOGIN("login", PermissionHandler.Level.GLOBAL),
    DISCOVERY("discovery", PermissionHandler.Level.GLOBAL),
    EDIT_SECURITY("security#edit", PermissionHandler.Level.GLOBAL),
    TASK_ASSIGN("task#assign", PermissionHandler.Level.GLOBAL),
    TASK_PREVIEWSTEP("task#preview_step", PermissionHandler.Level.GLOBAL),
    CONTROLTASK_EXECUTE("controltask#execute", PermissionHandler.Level.BOTH),
    ADMIN("admin", PermissionHandler.Level.GLOBAL),
    READ("read", PermissionHandler.Level.CI, new ReadPermissionHandler()),
    IMPORT_INITIAL("import#initial", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    IMPORT_UPGRADE("import#upgrade", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    IMPORT_REMOVE("import#remove", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    DEPLOY_INITIAL("deploy#initial", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    DEPLOY_UPGRADE("deploy#upgrade", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    UNDEPLOY("deploy#undeploy", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    EDIT_REPO("repo#edit", PermissionHandler.Level.CI),
    TASK_MOVESTEP("task#move_step", PermissionHandler.Level.BOTH, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    TASK_SKIPSTEP("task#skip_step", PermissionHandler.Level.BOTH, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    TASK_TAKEOVER("task#takeover", PermissionHandler.Level.BOTH, Metadata.ConfigurationItemRoot.ENVIRONMENTS);

    private PermissionHandler permissionHandler;
    private String permissionName;
    private PermissionHandler.Level level;
    private Metadata.ConfigurationItemRoot root;

    private Permission(String permissionName, PermissionHandler.Level level) {
        this.permissionName = permissionName;
        this.level = level;
        this.permissionHandler = new PermissionHandler(this);
    }

    private Permission(String permissionName, PermissionHandler.Level level, PermissionHandler permissionHandler) {
        this.permissionName = permissionName;
        this.level = level;
        this.permissionHandler = permissionHandler;
    }

    private Permission(String permissionName, PermissionHandler.Level level, Metadata.ConfigurationItemRoot root) {
        this(permissionName, level);
        this.root = root;
    }

    public static Permission find(String permissionName) {
        for (Permission permission : Permission.values()) {
            if (!permission.permissionName.equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public PermissionHandler.Level getLevel() {
        return this.level;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public boolean isApplicableTo(String id) {
        boolean idIsGlobal;
        boolean bl = idIsGlobal = (id = Strings.nullToEmpty((String)id)).isEmpty() || id.equals("global");
        if (this.level == PermissionHandler.Level.GLOBAL && idIsGlobal) {
            return true;
        }
        if (this.level == PermissionHandler.Level.BOTH && idIsGlobal) {
            return true;
        }
        if (this.level == PermissionHandler.Level.CI && idIsGlobal) {
            return false;
        }
        if (this.level != PermissionHandler.Level.BOTH && this.level != PermissionHandler.Level.CI) {
            return false;
        }
        if (this.root == null) {
            return true;
        }
        return id.startsWith(this.root.getRootNodeName());
    }
}

