/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.booter.local.validation.CollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceCollectionTypeValidator;
import com.xebialabs.deployit.booter.local.validation.ReferenceTypeValidator;
import com.xebialabs.deployit.booter.local.validation.RequiredValidator;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class LocalPropertyDescriptor
implements PropertyDescriptor {
    private LocalDescriptor declaringDescriptor;
    private String name;
    private Field field;
    private boolean asContainment;
    private String category;
    private String description;
    private String label;
    private boolean password;
    private boolean required;
    private Property.Size size;
    private PropertyKind kind;
    private List<String> enumValues;
    private Class<?> enumClass;
    private com.xebialabs.deployit.plugin.api.reflect.Type referencedType;
    private boolean hidden;
    private boolean inspectionProperty;
    private boolean requiredForInspection;
    private boolean isTransient;
    private Set<Validator<?>> validationRules = Sets.newHashSet();
    private Set<String> aliases = Sets.newHashSet();
    private static final Logger logger = LoggerFactory.getLogger(LocalPropertyDescriptor.class);

    private LocalPropertyDescriptor(Field field) {
        this.name = field.getName();
        this.field = field;
        field.setAccessible(true);
    }

    private LocalPropertyDescriptor(String name) {
        this.name = name;
        this.field = null;
    }

    LocalPropertyDescriptor(LocalPropertyDescriptor pd, LocalDescriptor newOwner) {
        this.declaringDescriptor = newOwner;
        this.name = pd.name;
        this.field = pd.field;
        this.asContainment = pd.asContainment;
        this.category = pd.category;
        this.description = pd.description;
        this.label = pd.label;
        this.password = pd.password;
        this.required = pd.required;
        this.size = pd.size;
        this.kind = pd.kind;
        this.enumValues = pd.enumValues;
        this.enumClass = pd.enumClass;
        this.referencedType = pd.referencedType;
        this.hidden = pd.hidden;
        this.inspectionProperty = pd.inspectionProperty;
        this.requiredForInspection = pd.requiredForInspection;
        this.validationRules = Sets.newHashSet(pd.validationRules);
        this.aliases = Sets.newHashSet(pd.aliases);
        this.isTransient = pd.isTransient();
        GlobalContext.register((PropertyDescriptor)this, pd);
    }

    static PropertyDescriptor from(LocalDescriptor descriptor, Field field) {
        Property annotation = field.getAnnotation(Property.class);
        LocalPropertyDescriptor propertyDescriptor = new LocalPropertyDescriptor(field);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initMetadata(annotation);
        propertyDescriptor.initType(annotation);
        LocalPropertyDescriptor.initInspectionMetadata(field, propertyDescriptor);
        LocalPropertyDescriptor.initValidationMetadata(field, propertyDescriptor);
        return propertyDescriptor;
    }

    private static void initValidationMetadata(Field field, LocalPropertyDescriptor propertyDescriptor) {
        propertyDescriptor.addDefaultValidationRules();
        for (Annotation annotation : field.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            propertyDescriptor.validationRules.add(ValidationRuleConverter.makeRule(annotation, propertyDescriptor));
        }
    }

    static LocalPropertyDescriptor from(LocalDescriptor descriptor, Element propertyElement) {
        String name = XmlUtils.getRequiredStringAttribute(propertyElement, "name");
        LocalPropertyDescriptor propertyDescriptor = new LocalPropertyDescriptor(name);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initSynthetic(propertyElement);
        return propertyDescriptor;
    }

    public void verify(Verifications verifications) {
        this.verifyName(verifications, "name");
        this.verifyName(verifications, "displayName");
        this.verifyName(verifications, "id");
        this.verifyName(verifications, "type");
        verifications.verify(!this.getName().contains("$"), "Cannot define a property named '%s' because it contains a '$'", this.getName());
        verifications.verify(!this.hidden || this.isTransient, "Hidden property '%s' should be transient", this);
        if (this.kind == PropertyKind.BOOLEAN && this.required) {
            logger.warn("Boolean property {} should not be required.", (Object)this);
            this.required = false;
        }
        verifications.verify(!this.asContainment || EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI, PropertyKind.CI).contains(this.kind), "'%s' can only be an as containment relation if it is a 'set_of_ci', 'list_of_ci' or 'ci' kind property", this);
        verifications.verify(this.referencedType == null || EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI, PropertyKind.CI).contains(this.kind), "'%s' can only have reference type '%s' set when it is a (Set/List of) CI kind property", this, this.referencedType);
        this.verifyAliases(verifications);
    }

    private void verifyAliases(Verifications verifications) {
        if (!this.aliases.isEmpty()) {
            for (PropertyDescriptor otherPd : this.declaringDescriptor.getPropertyDescriptors()) {
                LocalPropertyDescriptor pd = (LocalPropertyDescriptor)otherPd;
                if (otherPd.equals(this)) continue;
                verifications.verify(this.declaringDescriptor.getType(), !this.aliases.contains(pd.getName()), "Aliases of [%s] contain name [%s] which is an existing property.", this, pd.getName());
                ImmutableSet intersection = Sets.intersection(this.aliases, pd.aliases).immutableCopy();
                verifications.verify(this.declaringDescriptor.getType(), intersection.isEmpty(), "Aliases of [%s] conflict with aliases of [%s]. Conflicting: %s", this, pd, intersection);
            }
        }
    }

    private void verifyName(Verifications verifications, String name) {
        verifications.verify(!this.name.equals(name), "Cannot define a property named '%s' on %s", name, this.declaringDescriptor);
    }

    private static void initInspectionMetadata(Field field, LocalPropertyDescriptor propertyDescriptor) {
        if (field.isAnnotationPresent(InspectionProperty.class)) {
            propertyDescriptor.inspectionProperty = true;
            propertyDescriptor.requiredForInspection = field.getAnnotation(InspectionProperty.class).required();
        }
    }

    private void initMetadata(Property annotation) {
        this.category = annotation.category();
        this.label = Strings.isBlank(annotation.label()) ? Strings.deCamelize(this.name) : annotation.label();
        this.description = Strings.isBlank(annotation.description()) ? this.label : annotation.description();
        this.password = annotation.password();
        this.required = annotation.required();
        this.size = annotation.size();
        this.hidden = annotation.hidden();
        this.isTransient = this.hidden || annotation.isTransient();
    }

    private void initType(Property annotation) {
        Class<?> type = this.field.getType();
        if (type == Boolean.TYPE) {
            this.kind = PropertyKind.BOOLEAN;
        } else if (type == Integer.TYPE) {
            this.kind = PropertyKind.INTEGER;
        } else if (type == String.class) {
            this.kind = PropertyKind.STRING;
        } else if (type.isEnum()) {
            this.kind = PropertyKind.ENUM;
            this.initEnumValues(this.field.getType());
        } else if (type == Date.class) {
            this.kind = PropertyKind.DATE;
        } else if (ConfigurationItem.class.isAssignableFrom(type)) {
            this.kind = PropertyKind.CI;
            this.referencedType = com.xebialabs.deployit.plugin.api.reflect.Type.valueOf(type);
            this.asContainment = annotation.asContainment();
        } else if (Set.class.isAssignableFrom(type)) {
            this.initSetType(annotation);
        } else if (Map.class.isAssignableFrom(type)) {
            this.initMapType(annotation);
        } else if (List.class.isAssignableFrom(type)) {
            this.initListType(annotation);
        } else {
            throw new IllegalArgumentException(String.format("Type of %s not supported as an @Property field, found on %s.%s", type.getName(), this.field.getDeclaringClass().getName(), this.name));
        }
        GlobalContext.register((PropertyDescriptor)this, com.google.common.base.Strings.emptyToNull((String)annotation.defaultValue()));
    }

    private Object convertValue(String val) {
        if (val == null) {
            return null;
        }
        switch (this.kind) {
            case BOOLEAN: {
                return Boolean.parseBoolean(val);
            }
            case INTEGER: {
                if (val.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(val);
            }
            case STRING: {
                return val;
            }
            case ENUM: {
                for (Enum enumConstant : (Enum[])this.enumClass.getEnumConstants()) {
                    if (!enumConstant.name().equalsIgnoreCase(val)) continue;
                    return enumConstant;
                }
                throw new IllegalArgumentException("Value " + val + " not a member of enum " + this.field.getType());
            }
            case DATE: {
                return DatatypeConverter.parseDateTime((String)val).getTime();
            }
            case SET_OF_STRING: {
                return Sets.newLinkedHashSet(LocalPropertyDescriptor.splitValue(val));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(LocalPropertyDescriptor.splitValue(val));
            }
            case MAP_STRING_STRING: {
                return this.decodeMap(val);
            }
        }
        throw new IllegalArgumentException("Property " + this.name + " of kind " + this.kind + " cannot be converted from a string value");
    }

    private static Iterable<String> splitValue(String val) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)val);
    }

    private Map<String, String> decodeMap(String val) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String s : LocalPropertyDescriptor.splitValue(val)) {
            String[] split = s.split(":");
            Preconditions.checkArgument((com.google.common.base.Strings.emptyToNull((String)split[0]) != null ? 1 : 0) != 0, (String)"Property %s of kind %s cannot be converted from string value '%s' because of any empty key.", (Object[])new Object[]{this.name, this.kind, val});
            if (split.length == 1) {
                map.put(split[0], "");
                continue;
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    private void initSetType(Property annotation) {
        Class<?> setType = this.getGenericType(Set.class, 1, 0);
        if (setType == String.class) {
            this.kind = PropertyKind.SET_OF_STRING;
        } else if (ConfigurationItem.class.isAssignableFrom(setType)) {
            this.kind = PropertyKind.SET_OF_CI;
            this.referencedType = com.xebialabs.deployit.plugin.api.reflect.Type.valueOf(setType);
            this.asContainment = annotation.asContainment();
        } else {
            throw new IllegalStateException(String.format("Unsupported Set type encountered for [%s]. Only support String and ConfigurationItem", this.name));
        }
    }

    private void initMapType(Property annotation) {
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 0) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 1) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        this.kind = PropertyKind.MAP_STRING_STRING;
    }

    private void initListType(Property annotation) {
        Class<?> listType = this.getGenericType(List.class, 1, 0);
        if (listType == String.class) {
            this.kind = PropertyKind.LIST_OF_STRING;
        } else if (ConfigurationItem.class.isAssignableFrom(listType)) {
            this.kind = PropertyKind.LIST_OF_CI;
            this.referencedType = com.xebialabs.deployit.plugin.api.reflect.Type.valueOf(listType);
            this.asContainment = annotation.asContainment();
        } else {
            throw new IllegalStateException(String.format("Unsupported List type encountered for [%s]. Only support String and ConfigurationItem", this.name));
        }
    }

    private Class<?> getGenericType(Class<?> collectionClass, int nrExpectedTypes, int indexOfType) {
        Type genericType = this.field.getGenericType();
        Preconditions.checkArgument((boolean)(genericType instanceof ParameterizedType), (String)"The field %s.%s is a %s but it isn't a generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, genericType});
        Object[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
        Preconditions.checkArgument((actualTypeArguments.length == nrExpectedTypes ? 1 : 0) != 0, (String)"The field %s is a %s.%s but it doesn't have the right generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, actualTypeArguments});
        Preconditions.checkArgument((boolean)(actualTypeArguments[indexOfType] instanceof Class), (String)"The field %s.%s is a %s but it is not a concrete subclass (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, Arrays.toString(actualTypeArguments)});
        return (Class)actualTypeArguments[indexOfType];
    }

    private void initEnumValues(Class<?> enumClass) {
        this.enumValues = Lists.newArrayList();
        this.enumClass = enumClass;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            this.enumValues.add(enumValue.name());
        }
    }

    void overrideWith(LocalPropertyDescriptor superDescriptor) {
        Preconditions.checkArgument((superDescriptor.getKind() == this.getKind() ? 1 : 0) != 0, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but kind attribute does not match. Derived kind: '%s'. Super kind: '%s'.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), superDescriptor.getDeclaringDescriptor().getType(), this.getKind(), superDescriptor.getKind()});
        this.checkOverrideArgument(superDescriptor.isAsContainment() == this.isAsContainment(), "asContainment", superDescriptor.isAsContainment(), superDescriptor);
        this.checkOverrideArgument(superDescriptor.getReferencedType() == null && this.getReferencedType() == null || superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().equals((Object)this.getReferencedType()) || superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().isSuperTypeOf(this.getReferencedType()), "referenceType", superDescriptor.getReferencedType() + " or a subtype thereof", superDescriptor);
        this.checkOverrideArgument(superDescriptor.enumClass == this.enumClass, "enumClass", superDescriptor.enumClass, superDescriptor);
        this.checkOverrideArgument(superDescriptor.isPassword() == this.isPassword(), "password", superDescriptor.isPassword(), superDescriptor);
        if (superDescriptor.isRequired()) {
            this.checkOverrideArgument(this.isRequired(), "required", superDescriptor.isRequired(), superDescriptor);
        }
        this.field = superDescriptor.field;
    }

    private void checkOverrideArgument(boolean condition, String attribute, Object expectedValue, PropertyDescriptor superDescriptor) {
        String attributeErrorTemplate = "Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.";
        Preconditions.checkArgument((boolean)condition, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), ((LocalPropertyDescriptor)superDescriptor).getDeclaringDescriptor().getType(), attribute, expectedValue});
    }

    private void initSynthetic(Element propertyElement) {
        this.kind = PropertyKind.valueOf((String)XmlUtils.getOptionalStringAttribute(propertyElement, "kind", PropertyKind.STRING.name()).toUpperCase());
        this.category = XmlUtils.getOptionalStringAttribute(propertyElement, "category", "Common");
        this.label = XmlUtils.getOptionalStringAttribute(propertyElement, "label", Strings.deCamelize(this.name));
        this.description = XmlUtils.getOptionalStringAttribute(propertyElement, "description", this.label);
        this.required = XmlUtils.getOptionalBooleanAttribute(propertyElement, "required", true);
        this.password = XmlUtils.getOptionalBooleanAttribute(propertyElement, "password", false);
        this.asContainment = XmlUtils.getOptionalBooleanAttribute(propertyElement, "as-containment", false);
        this.size = Property.Size.valueOf((String)XmlUtils.getOptionalStringAttribute(propertyElement, "size", Property.Size.MEDIUM.name()).toUpperCase());
        String defaultValueAttr = XmlUtils.getOptionalStringAttribute(propertyElement, "default", null);
        this.hidden = XmlUtils.getOptionalBooleanAttribute(propertyElement, "hidden", false);
        this.inspectionProperty = XmlUtils.getOptionalBooleanAttribute(propertyElement, "inspectionProperty", false);
        this.aliases = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)XmlUtils.getOptionalStringAttribute(propertyElement, "aliases", "")));
        boolean bl = this.isTransient = this.hidden || XmlUtils.getOptionalBooleanAttribute(propertyElement, "transient", false);
        if (this.kind == PropertyKind.ENUM) {
            String enumClassAttributeValue = XmlUtils.getRequiredStringAttribute(propertyElement, "enum-class", "for property " + this.name + " of kind " + this.kind);
            try {
                this.enumClass = Class.forName(enumClassAttributeValue);
                if (!this.enumClass.isEnum()) {
                    throw new IllegalArgumentException("enum-class supplied for property " + this.name + " of kind " + this.kind + " is not an enum: " + enumClassAttributeValue);
                }
                this.initEnumValues(this.enumClass);
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException("Unknown enum-class supplied for property " + this.name + " of kind " + this.kind + ": " + enumClassAttributeValue, exc);
            }
        }
        if (this.kind == PropertyKind.CI || this.kind == PropertyKind.SET_OF_CI || this.kind == PropertyKind.LIST_OF_CI) {
            this.referencedType = com.xebialabs.deployit.plugin.api.reflect.Type.valueOf((String)XmlUtils.getRequiredStringAttribute(propertyElement, "referenced-type", "for property " + this.name + " of kind " + this.kind));
        }
        this.initSyntheticValidationRules(propertyElement);
        this.addDefaultValidationRules();
        GlobalContext.register((PropertyDescriptor)this, defaultValueAttr);
    }

    private void addDefaultValidationRules() {
        if (this.required && !this.asContainment && this.kind != PropertyKind.BOOLEAN) {
            this.validationRules.add(new RequiredValidator());
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING).contains(this.kind)) {
            this.validationRules.add(new CollectionTypeValidator(this));
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(this.kind)) {
            this.validationRules.add(new ReferenceCollectionTypeValidator(this));
        } else if (PropertyKind.CI == this.kind) {
            this.validationRules.add(new ReferenceTypeValidator(this));
        }
    }

    private void initSyntheticValidationRules(Element propertyElement) {
        XmlUtils.forEach(XmlUtils.childByName(propertyElement, (Predicate<String>)Predicates.equalTo((Object)"rule")), new XmlUtils.Closure<Element>(){

            @Override
            public void call(Element element) {
                LocalPropertyDescriptor.this.validationRules.add(ValidationRuleConverter.makeRule(element, LocalPropertyDescriptor.this));
            }
        });
    }

    static PropertyDescriptor generateDeployableFrom(LocalDescriptor descriptor, PropertyDescriptor deployedPropertyDescriptor) {
        LocalPropertyDescriptor propertyDescriptor = new LocalPropertyDescriptor(deployedPropertyDescriptor.getName());
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.generateDeployable(deployedPropertyDescriptor);
        return propertyDescriptor;
    }

    private void generateDeployable(PropertyDescriptor deployedPropertyDescriptor) {
        this.kind = deployedPropertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : deployedPropertyDescriptor.getKind();
        this.category = deployedPropertyDescriptor.getCategory();
        this.label = deployedPropertyDescriptor.getLabel();
        this.description = String.format("%s (%s)", deployedPropertyDescriptor.getDescription(), deployedPropertyDescriptor.getKind().name().toLowerCase());
        this.required = false;
        this.password = deployedPropertyDescriptor.isPassword();
        this.size = deployedPropertyDescriptor.getSize();
        this.field = null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsContainment() {
        return this.asContainment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property.Size getSize() {
        return this.size;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public Descriptor getDeclaringDescriptor() {
        return this.declaringDescriptor;
    }

    public com.xebialabs.deployit.plugin.api.reflect.Type getReferencedType() {
        return this.referencedType;
    }

    public Object getDefaultValue() {
        return this.convertValue(GlobalContext.lookup(this));
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Object get(ConfigurationItem item) {
        if (this.field != null) {
            try {
                return this.field.get(item);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot get field " + this.field, e);
            }
        }
        Map synth = (Map)ReflectionUtils.getField(item, this.declaringDescriptor.getSyntheticPropertiesField());
        return synth.get(this.name);
    }

    public void set(ConfigurationItem item, Object value) {
        if (value instanceof String) {
            value = this.convertValue((String)value);
        } else if (value == null) {
            value = this.getDefaultValue();
        }
        try {
            if (this.field != null) {
                if (value == null) {
                    return;
                }
                this.field.set(item, value);
            } else {
                Map synth = (Map)ReflectionUtils.getField(item, this.declaringDescriptor.getSyntheticPropertiesField());
                synth.put(this.name, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot set field " + this.field, e);
        }
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        Object left = this.get(item);
        Object right = this.get(other);
        return this.areValuesEqual(left, right, itemsBeingCompared);
    }

    private boolean areValuesEqual(Object itemValue, Object otherValue, Set<String> itemsBeingCompared) {
        if (itemValue == null) {
            return otherValue == null;
        }
        if (otherValue == null) {
            return false;
        }
        switch (this.kind) {
            case SET_OF_STRING: {
                return Sets.symmetricDifference((Set)((Set)itemValue), (Set)((Set)otherValue)).isEmpty();
            }
            case SET_OF_CI: {
                Function<ConfigurationItem, String> f = new Function<ConfigurationItem, String>(){

                    public String apply(ConfigurationItem from) {
                        return from.getName();
                    }
                };
                Iterable cis = Iterables.concat((Iterable)((Set)itemValue), (Iterable)((Set)otherValue));
                ImmutableListMultimap index = Multimaps.index((Iterable)cis, (Function)f);
                for (String key : index.keySet()) {
                    LocalDescriptor descriptor;
                    Collection cisToCompare = index.get((Object)key);
                    if (cisToCompare.size() != 2) {
                        return false;
                    }
                    Iterator itemIterator = cisToCompare.iterator();
                    ConfigurationItem lhs = (ConfigurationItem)itemIterator.next();
                    ConfigurationItem rhs = (ConfigurationItem)itemIterator.next();
                    if (lhs.getType().equals((Object)rhs.getType()) && (descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((com.xebialabs.deployit.plugin.api.reflect.Type)lhs.getType())).areEqual(lhs, rhs, itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
            case CI: {
                ConfigurationItem itemValueAsCi = (ConfigurationItem)itemValue;
                ConfigurationItem otherValueAsCi = (ConfigurationItem)otherValue;
                if (itemValueAsCi.getName().equals(otherValueAsCi.getName())) {
                    LocalDescriptor descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((com.xebialabs.deployit.plugin.api.reflect.Type)itemValueAsCi.getType());
                    return descriptor.areEqual(itemValueAsCi, otherValueAsCi, itemsBeingCompared);
                }
                return false;
            }
            case MAP_STRING_STRING: {
                Map left = (Map)itemValue;
                Map right = (Map)otherValue;
                return Maps.difference((Map)left, (Map)right).areEqual();
            }
            case LIST_OF_STRING: {
                List leftStrings = (List)itemValue;
                List rightStrings = (List)otherValue;
                return ((Object)leftStrings).equals(rightStrings);
            }
            case LIST_OF_CI: {
                List lhs = (List)itemValue;
                List rhs = (List)otherValue;
                if (lhs.size() != rhs.size()) {
                    return false;
                }
                Iterator lIter = lhs.iterator();
                Iterator rIter = rhs.iterator();
                while (lIter.hasNext()) {
                    LocalDescriptor descriptor;
                    ConfigurationItem lItem = (ConfigurationItem)lIter.next();
                    ConfigurationItem rItem = (ConfigurationItem)rIter.next();
                    if (lItem.getName().equals(rItem.getName()) && lItem.getType().equals((Object)rItem.getType()) && (descriptor = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((com.xebialabs.deployit.plugin.api.reflect.Type)lItem.getType())).areEqual(lItem, rItem, itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
        }
        return itemValue.equals(otherValue);
    }

    void validate(final ConfigurationItem ci, final List<ValidationMessage> messages) {
        ValidationContext context = new ValidationContext(){

            public void error(String message, Object ... params) {
                messages.add(new ValidationMessage(ci.getId(), LocalPropertyDescriptor.this.name, String.format(message, params)));
            }
        };
        for (Validator<?> validationRule : this.validationRules) {
            validationRule.validate(this.get(ci), context);
        }
    }

    public boolean isInspectionProperty() {
        return this.inspectionProperty;
    }

    public boolean isRequiredForInspection() {
        return this.requiredForInspection;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getFqn() {
        return this.declaringDescriptor.getType() + "." + this.name;
    }

    public String toString() {
        return this.getFqn();
    }

    public Object emptyValue() {
        switch (this.kind) {
            case BOOLEAN: {
                return false;
            }
            case SET_OF_STRING: 
            case SET_OF_CI: {
                return Sets.newHashSet();
            }
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return Lists.newArrayList();
            }
            case MAP_STRING_STRING: {
                return Maps.newHashMap();
            }
        }
        return null;
    }

    public Field getField() {
        return this.field;
    }
}

