/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.ManifestBasedDarImporter;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderScanningFailedException;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private Validator validator;
    private File importablePackageDirectory;
    private List<Importer> importers = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ImporterServiceImpl.class);

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, Validator validator) {
        this.repositoryService = repositoryService;
        this.validator = validator;
    }

    @PostConstruct
    public void initImporters() {
        Set importers = Scannit.getInstance().getSubTypesOf(Importer.class);
        logger.debug("Found importers: {}", (Object)importers);
        for (Class importer : importers) {
            try {
                if (importer.isInterface() || Modifier.isAbstract(importer.getModifiers()) || importer.equals(ManifestBasedDarImporter.class) || importer.equals(XmlManifestDarImporter.class)) continue;
                logger.debug("Importer {} registered.", (Object)importer);
                this.importers.add((Importer)importer.newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate importer: " + importer, e);
            }
        }
        Collections.sort(this.importers, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
        });
        this.importers.add((Importer)new XmlManifestDarImporter(this.repositoryService));
        this.importers.add((Importer)new ManifestBasedDarImporter());
        logger.debug("Importer {} registered.", XmlManifestDarImporter.class);
        logger.debug("Importer {} registered.", ManifestBasedDarImporter.class);
        logger.info("Importers configured in Deployit: {}", this.importers);
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory = importablePackageDirectory;
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    @Override
    public List<String> listPackages() {
        ArrayList packagesFound = Lists.newArrayList();
        for (Importer importer : this.importers) {
            if (!(importer instanceof ListableImporter)) continue;
            packagesFound.addAll(((ListableImporter)importer).list(this.importablePackageDirectory));
        }
        Collections.sort(packagesFound);
        return packagesFound;
    }

    @Override
    public String importPackage(ImportSource source) {
        try {
            for (Importer importer : this.importers) {
                if (!importer.canHandle(source)) continue;
                String string = this.doImport(source, importer);
                return string;
            }
            throw new ImporterException("Unable to obtain the package to import from the import source", new Object[0]);
        }
        finally {
            source.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doImport(ImportSource source, Importer importer) {
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        boolean isUpgrade = this.isUpgrade(packageInfo);
        this.checkPermission(isUpgrade, packageInfo);
        this.checkImported(packageInfo);
        try {
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, isUpgrade, toCreate);
            this.validate(toCreate);
            this.repositoryService.create(toCreate.toArray(new ConfigurationItem[toCreate.size()]));
            String string = importedPackage.getVersion().getId();
            return string;
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
    }

    private void scanPlaceholders(ImportedPackage importedPackage) {
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            for (Deployable deployable : importedPackage.getDeployables()) {
                if (!(deployable instanceof SourceArtifact)) continue;
                try {
                    Placeholders.scanPlaceholders((SourceArtifact)((SourceArtifact)deployable), (PlaceholderScanner)new MustachePlaceholderScanner());
                }
                catch (RuntimeException re) {
                    PlaceholderScanningFailedException.throwException((String)deployable.getId(), (RuntimeException)re);
                }
            }
        }
    }

    private void checkImported(PackageInfo packageInfo) {
        if (this.repositoryService.exists(IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion()))) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        if (!isUpgrade) {
            toCreateCollector.add((ConfigurationItem)importedPackage.getApplication());
        }
        toCreateCollector.add((ConfigurationItem)importedPackage.getVersion());
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            HashSet deployables = Sets.newHashSet((Iterable)importedPackage.getDeployables());
            toCreateCollector.addAll(deployables);
            for (ConfigurationItem ci : deployables) {
                this.createEmbeddeds(ci, toCreateCollector);
            }
        }
    }

    private void createEmbeddeds(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getKind() != PropertyKind.SET_OF_CI || !propertyDescriptor.getReferencedType().getDescriptor().isAssignableTo(EmbeddedDeployable.class)) continue;
            Collection embeddeds = (Collection)propertyDescriptor.get(ci);
            for (ConfigurationItem embedded : embeddeds) {
                if (toCreateCollector.contains(embedded)) continue;
                toCreateCollector.add(embedded);
                this.createEmbeddeds(embedded, toCreateCollector);
            }
        }
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        ArrayList msgs = Lists.newArrayList();
        for (ConfigurationItem toCreateEntity : toCreate) {
            msgs.addAll(this.validator.validate(toCreateEntity, (List)Lists.newArrayList(toCreate)));
        }
        if (!msgs.isEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", ((Object)msgs).toString());
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        List applications = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)));
        String app = null;
        for (ConfigurationItemData application : applications) {
            if (!this.subStringAfterLast(application.getId(), "/").equals(packageInfo.getApplicationName())) continue;
            Preconditions.checkState((app == null ? 1 : 0) != 0, (String)"Found more than 1 udm.Application with the same name: [%s] and [%s]", (Object[])new Object[]{app, application});
            app = application.getId();
        }
        if (app != null) {
            packageInfo.setDirectories(app.substring(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName().length(), app.length() - packageInfo.getApplicationName().length()));
            return true;
        }
        return false;
    }

    private String subStringAfterLast(String s, String sep) {
        if (s.contains(sep)) {
            return s.substring(s.lastIndexOf(sep) + sep.length());
        }
        return s;
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        if (isUpgrade) {
            this.checkPermission(Permission.IMPORT_UPGRADE, packageInfo.getApplicationId());
        } else {
            this.checkPermission(Permission.IMPORT_INITIAL, packageInfo.getApplicationId());
        }
    }

    void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }
}

