/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.replacer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.engine.replacer.PlaceholderReplacer;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TFileWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Placeholders {
    public static LoadingCache<String, Pattern> patternMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String key) throws Exception {
            return Pattern.compile(key, 6);
        }
    });
    private static final Logger logger = LoggerFactory.getLogger(Placeholders.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanPlaceholders(SourceArtifact artifact, PlaceholderScanner scanner) {
        Preconditions.checkArgument((artifact.getFile() != null ? 1 : 0) != 0, (Object)(artifact + " has no file"));
        Preconditions.checkArgument((boolean)(artifact.getFile() instanceof LocalFile), (Object)("Cannot scan for placeholders in " + artifact + " because its file is a " + artifact.getFile().getClass().getName() + " and not a " + LocalFile.class.getName()));
        artifact.setPlaceholders((Set)Sets.newTreeSet());
        if (artifact.hasProperty("scanPlaceholders") && !((Boolean)artifact.getProperty("scanPlaceholders")).booleanValue()) {
            return;
        }
        TFile from = Placeholders.asTfile(artifact.getFile());
        try {
            Placeholders.doScanPlaceholders(artifact, from, scanner, true);
        }
        finally {
            Placeholders.umountQuietly(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScanPlaceholders(SourceArtifact artifact, TFile from, PlaceholderScanner scanner, boolean isRoot) {
        if (Placeholders.shouldExcludeFile(from, artifact, isRoot)) {
            return;
        }
        if (from.isDirectory()) {
            try {
                for (TFile f : from.listFiles()) {
                    f = Placeholders.asTfile((File)f);
                    Placeholders.doScanPlaceholders(artifact, f, scanner, false);
                }
            }
            finally {
                Placeholders.umountQuietly(from);
            }
        } else if (Placeholders.isTextFile(from.getName(), artifact.getTextFileNamesRegex())) {
            artifact.getPlaceholders().addAll(Placeholders.readPlaceholders(from, scanner));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readPlaceholders(TFile from, PlaceholderScanner scanner) {
        Set<String> set;
        TFileReader in = null;
        try {
            logger.trace("Reading placeholders from file {}", (Object)from.getPath());
            in = new TFileReader(from);
            set = scanner.scan((Reader)in);
        }
        catch (IOException exc) {
            try {
                throw new RuntimeIOException("Cannot scan for placeholders in " + from, (Throwable)exc);
                catch (RuntimeException exc2) {
                    throw new RuntimeException("Cannot scan for placeholders in " + from, exc2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, PlaceholderReplacer replacer) {
        block11: {
            if (derivedArtifact.getSourceArtifact() == null) {
                derivedArtifact.setFile(null);
            } else {
                OverthereFile fromFile = derivedArtifact.getSourceArtifact().getFile();
                Preconditions.checkArgument((fromFile != null ? 1 : 0) != 0, (String)"%s has no file", (Object[])new Object[]{derivedArtifact.getSourceArtifact()});
                Preconditions.checkArgument((boolean)(fromFile instanceof LocalFile), (String)"Cannot replace placeholders in %s because its file is not a LocalFile but a %s", (Object[])new Object[]{derivedArtifact.getSourceArtifact(), fromFile.getClass().getName()});
                TFile from = null;
                try {
                    boolean isBinaryFile;
                    from = Placeholders.getTFileWithCorrectDirectoryDetection(fromFile);
                    boolean bl = isBinaryFile = from.isFile() && !Placeholders.isTextFile(fromFile.getName(), Placeholders.getTextFileNamesRegex(derivedArtifact));
                    if (derivedArtifact.getPlaceholders().isEmpty() || isBinaryFile) {
                        derivedArtifact.setFile(fromFile);
                        break block11;
                    }
                    OverthereFile derivedFile = Placeholders.getOutputFile(derivedArtifact);
                    try {
                        fromFile.copyTo(derivedFile);
                        TFile to = Placeholders.getTFileWithCorrectDirectoryDetection(derivedFile);
                        try {
                            Placeholders.doReplacePlaceholders(derivedArtifact, to, replacer, true);
                            Placeholders.saveArchive(to);
                        }
                        finally {
                            Placeholders.umountQuietly(to);
                        }
                        derivedArtifact.setFile(derivedFile);
                        Preconditions.checkState((derivedFile.getParentFile().listFiles().size() == 1 ? 1 : 0) != 0, (String)"Should only be one file in the deployed dir, was %s", (Object[])new Object[]{derivedFile.getParentFile().listFiles()});
                    }
                    catch (Throwable throwable) {
                        Preconditions.checkState((derivedFile.getParentFile().listFiles().size() == 1 ? 1 : 0) != 0, (String)"Should only be one file in the deployed dir, was %s", (Object[])new Object[]{derivedFile.getParentFile().listFiles()});
                        throw throwable;
                    }
                }
                finally {
                    Placeholders.umountQuietly(from);
                }
            }
        }
    }

    private static TFile getTFileWithCorrectDirectoryDetection(OverthereFile derivedFile) {
        TFile to;
        if (derivedFile.isDirectory()) {
            to = new TFile(derivedFile.getPath(), TArchiveDetector.NULL);
        } else {
            String parentPath = derivedFile.getParentFile().getPath();
            to = new TFile((File)new TFile(parentPath, TArchiveDetector.NULL), derivedFile.getName(), TArchiveDetector.ALL);
        }
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReplacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, TFile to, PlaceholderReplacer replacer, boolean isRoot) {
        boolean include;
        boolean bl = include = !Placeholders.shouldExcludeFile(to, derivedArtifact.getSourceArtifact(), isRoot);
        if (include && to.isDirectory()) {
            try {
                for (TFile t : to.listFiles()) {
                    t = Placeholders.asTfile((File)t);
                    Placeholders.doReplacePlaceholders(derivedArtifact, t, replacer, false);
                }
            }
            finally {
                Placeholders.umountQuietly(to);
            }
        } else if (include && Placeholders.isTextFile(to.getName(), Placeholders.getTextFileNamesRegex(derivedArtifact))) {
            Placeholders.replace(to, replacer, derivedArtifact.getPlaceholders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replace(TFile toBeReplaced, PlaceholderReplacer replacer, Map<String, String> resolution) {
        File tempFile = null;
        try {
            Object reader = null;
            FileWriter writer = null;
            tempFile = File.createTempFile(toBeReplaced.getName(), ".tmp");
            try {
                reader = new TFileReader(toBeReplaced);
                writer = new FileWriter(tempFile);
                replacer.replace((Reader)reader, writer, resolution);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                Closeables.closeQuietly(writer);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)reader);
            Closeables.closeQuietly((Closeable)writer);
            try {
                reader = new FileReader(tempFile);
                writer = new TFileWriter(toBeReplaced);
                CharStreams.copy((Readable)reader, (Appendable)writer);
            }
            finally {
                ((Reader)reader).close();
                ((Writer)writer).close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot replace placeholders in " + toBeReplaced, (Throwable)exc);
        }
        finally {
            if (tempFile != null && !tempFile.delete()) {
                logger.warn("Couldn't delete temporary file: {}", (Object)tempFile);
            }
        }
    }

    private static OverthereFile getOutputFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        String name;
        OverthereFile deployedArtifactDir;
        OverthereFile sourceFile = derivedArtifact.getSourceArtifact().getFile();
        OverthereFile workDir = sourceFile.getParentFile();
        Random r = new Random();
        String baseName = derivedArtifact.getName();
        while ((deployedArtifactDir = workDir.getFile(name = baseName + Math.abs(r.nextInt()))).exists()) {
        }
        deployedArtifactDir.mkdir();
        return deployedArtifactDir.getFile(sourceFile.getName());
    }

    private static File saveArchive(TFile outputArchive) {
        if (outputArchive.isArchive() && outputArchive.getEnclArchive() == null && outputArchive.isDirectory()) {
            try {
                TFile.umount((TFile)outputArchive);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot write archive " + outputArchive, (Throwable)exc);
            }
        }
        return new File(outputArchive.getPath());
    }

    private static boolean shouldExcludeFile(TFile f, SourceArtifact artifact, boolean isRoot) {
        if (isRoot && artifact instanceof FolderArtifact) {
            return false;
        }
        if (Strings.emptyToNull((String)artifact.getExcludeFileNamesRegex()) == null) {
            return false;
        }
        Pattern excludeFileNamesPattern = (Pattern)patternMap.getUnchecked((Object)artifact.getExcludeFileNamesRegex());
        Matcher excludeFileNamesMatcher = excludeFileNamesPattern.matcher(f.getPath());
        boolean exclude = excludeFileNamesMatcher.matches();
        if (exclude) {
            logger.debug("Excluding file {} from scanning", (Object)f);
        }
        return exclude;
    }

    private static boolean isTextFile(String name, String textFileNamesRegex) {
        Preconditions.checkNotNull((Object)textFileNamesRegex, (Object)"Regex is null");
        Pattern textFileNamesPattern = (Pattern)patternMap.getUnchecked((Object)textFileNamesRegex);
        Matcher textFileNamesMatcher = textFileNamesPattern.matcher(name);
        boolean isTextFile = textFileNamesMatcher.matches();
        logger.debug("Determined {} to be a {} file", (Object)name, (Object)(isTextFile ? "text" : "binary"));
        return isTextFile;
    }

    private static String getTextFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getTextFileNamesRegex();
    }

    private static TFile asTfile(OverthereFile file) {
        File fromFile = ((LocalFile)file).getFile();
        return Placeholders.asTfile(fromFile);
    }

    private static TFile asTfile(File fromFile) {
        File from = fromFile;
        if (from instanceof TFile) {
            from = ((TFile)from).getFile();
        }
        if (from.isDirectory()) {
            return new TFile(from, TArchiveDetector.NULL);
        }
        return new TFile(from);
    }

    private static void umountQuietly(TFile file) {
        if (file != null && file.isArchive() && file.getEnclArchive() == null) {
            try {
                TFile.umount((TFile)file);
            }
            catch (Exception e) {
                logger.error("Couldn't umount [{}], ignoring exception.", (Object)file);
                logger.debug("Exception while umounting was: ", (Throwable)e);
            }
        }
    }
}

