/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleReader;
import org.apache.jackrabbit.core.persistence.util.BundleWriter;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.util.StringIndex;

public class BundleBinding {
    static final int BINARY_IN_BLOB_STORE = -1;
    static final int BINARY_IN_DATA_STORE = -2;
    static final NodeId NULL_PARENT_ID = new NodeId("bb4e9d10-d857-11df-937b-0800200c9a66");
    static final int VERSION_1 = 1;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    static final int VERSION_CURRENT = 3;
    protected final StringIndex nsIndex;
    protected final StringIndex nameIndex;
    protected final BLOBStore blobStore;
    protected long minBlobSize = 16384L;
    protected final ErrorHandling errorHandling;
    protected final DataStore dataStore;

    public BundleBinding(ErrorHandling errorHandling, BLOBStore blobStore, StringIndex nsIndex, StringIndex nameIndex, DataStore dataStore) {
        this.errorHandling = errorHandling;
        this.nsIndex = nsIndex;
        this.nameIndex = nameIndex;
        this.blobStore = blobStore;
        this.dataStore = dataStore;
    }

    public long getMinBlobSize() {
        return this.minBlobSize;
    }

    public void setMinBlobSize(long minBlobSize) {
        this.minBlobSize = minBlobSize;
    }

    public BLOBStore getBlobStore() {
        return this.blobStore;
    }

    public NodePropBundle readBundle(InputStream in, NodeId id) throws IOException {
        return new BundleReader(this, in).readBundle(id);
    }

    public void writeBundle(OutputStream out, NodePropBundle bundle) throws IOException {
        new BundleWriter(this, out).writeBundle(bundle);
    }
}

