/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionLister {
    private final JcrTemplate jcrTemplate;
    private final RepositoryService repositoryService;

    @Autowired
    public PermissionLister(JcrTemplate jcrTemplate, RepositoryService repositoryService) {
        this.jcrTemplate = jcrTemplate;
        this.repositoryService = repositoryService;
    }

    public Multimap<String, String> listPermissions(Role role) {
        return this.listPermissions(Lists.newArrayList((Object[])new Role[]{role}));
    }

    public Multimap<String, String> listPermissions(final List<Role> roles) {
        final HashMultimap permissions = HashMultimap.create();
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws RepositoryException {
                PermissionLister.this.readGlobalPermissions(session, (HashMultimap<String, String>)permissions, roles);
                PermissionLister.this.readCiLevelPermissions(session, (HashMultimap<String, String>)permissions, roles);
                return null;
            }
        });
        return permissions;
    }

    private void readCiLevelPermissions(Session session, HashMultimap<String, String> permissionList, List<Role> roles) throws RepositoryException {
        List<ConfigurationItemData> directories = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Directory.class)));
        List<ConfigurationItemData> roots = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Root.class)));
        for (ConfigurationItemData ci : Iterables.concat(directories, roots)) {
            Node s = Permissions.readSecurable(ci.getId(), session);
            this.readPermissionsFromNode(permissionList, roles, ci.getId(), s);
        }
    }

    private void readPermissionsFromNode(HashMultimap<String, String> permissionList, final List<Role> roles, String ci, Node s) throws RepositoryException {
        Map<String, String> permissions = Permissions.readPermissionMap(s);
        permissionList.putAll((Object)ci, (Iterable)Collections2.transform((Collection)Sets.filter(permissions.entrySet(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                return PermissionLister.this.checkAllowed(input.getValue(), roles);
            }
        }), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> input) {
                return input.getKey();
            }
        }));
    }

    private void readGlobalPermissions(Session session, HashMultimap<String, String> permissionList, List<Role> roles) throws RepositoryException {
        Node securityNode = session.getNode("/$configuration/security");
        this.readPermissionsFromNode(permissionList, roles, "global", securityNode);
    }

    private boolean checkAllowed(String allowedRoles, List<Role> principals) {
        Iterable<Integer> split = Permissions.splitRoles(allowedRoles);
        return Iterables.any(split, (Predicate)Predicates.in((Collection)Lists.newArrayList(Permissions.rolesToIds(principals))));
    }
}

