/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedPropertySetter {
    private RepositoryService repository;
    private final TypeCalculator calculator;
    private static final Set<String> UDM_FIELDS = Sets.newHashSet((Object[])new String[]{"placeholders", "deployable", "container"});
    private static final Logger logger = LoggerFactory.getLogger(DeployedPropertySetter.class);

    @Autowired
    public DeployedPropertySetter(RepositoryService repository, TypeCalculator typeCalculator) {
        this.repository = repository;
        this.calculator = typeCalculator;
    }

    public void setProperties(EmbeddedDeployedContainer deployed, EmbeddedDeployedContainer existingDeployed, ConsolidatedDictionary dictionary) {
        Checks.checkArgument((existingDeployed == null || deployed.getType().equals((Object)existingDeployed.getType()) ? 1 : 0) != 0, (String)"New and existing deployed types should be equal when upgrading (%s)", (Object[])new Object[]{deployed.getType()});
        ConfigurationItem deployable = (ConfigurationItem)deployed.getProperty("deployable");
        Descriptor deployedDesc = deployed.getType().getDescriptor();
        Descriptor deployableDesc = deployable.getType().getDescriptor();
        for (PropertyDescriptor deployedPropDesc : deployedDesc.getPropertyDescriptors()) {
            String name = deployedPropDesc.getName();
            if (UDM_FIELDS.contains(name)) continue;
            if (this.isEmbeddedProperty(deployedPropDesc)) {
                this.generateEmbeddeds(deployed, deployedPropDesc, dictionary);
                continue;
            }
            Object existingDeployedValue = this.getExistingDeployedValue(existingDeployed, name);
            Object existingDeployableValue = this.getExistingDeployableValue(existingDeployed, name);
            PropertyDescriptor deployablePropDesc = deployableDesc.getPropertyDescriptor(name);
            Object deployableValue = null;
            if (deployablePropDesc != null) {
                deployableValue = deployablePropDesc.get(deployable);
            }
            Object valueToSet = existingDeployedValue;
            PropertyDescriptor valueToSetPropDesc = deployedPropDesc;
            if (existingDeployableValue != null && this.hasPlaceholders(existingDeployableValue, deployablePropDesc)) {
                valueToSet = deployableValue;
                valueToSetPropDesc = deployablePropDesc;
            } else if (existingDeployableValue == null && deployableValue != null) {
                valueToSet = deployableValue;
                valueToSetPropDesc = deployablePropDesc;
            } else if (existingDeployableValue != null) {
                PropertyDescriptor existingDeployablePropDesc = existingDeployed.getDeployable().getType().getDescriptor().getPropertyDescriptor(name);
                Object resolvedExistingDeployableValue = this.convertIfNeeded(existingDeployableValue, existingDeployablePropDesc, deployedPropDesc);
                if (existingDeployedValue != null && resolvedExistingDeployableValue.toString().equals(existingDeployedValue.toString())) {
                    valueToSet = deployableValue;
                    valueToSetPropDesc = deployablePropDesc;
                }
            }
            if (this.isNullOrEmpty(valueToSet, valueToSetPropDesc)) {
                this.setDeployedFromDictionary(deployed, dictionary, deployedPropDesc, deployablePropDesc);
                continue;
            }
            Object deployedPropertyValue = null;
            try {
                deployedPropertyValue = dictionary.resolve(valueToSet, valueToSetPropDesc);
                this.checkWhetherValueIsSecureAndPropertyIsPassword(deployedPropertyValue, deployedPropDesc, valueToSet);
                deployedPropertyValue = this.convertIfNeeded(deployedPropertyValue, valueToSetPropDesc, deployedPropDesc);
            }
            catch (DictionaryValueException e) {
                deployedPropertyValue = existingDeployedValue;
                logger.info("Could not resolve dictionary keys for property " + deployablePropDesc + " on " + deployed + ".");
                logger.trace("Exception was", (Throwable)e);
            }
            try {
                deployedPropDesc.set((ConfigurationItem)deployed, deployedPropertyValue);
            }
            catch (RuntimeException exc) {
                logger.error("Could not convert (resolved) value to correct type for property " + deployedPropDesc + " of " + deployed + ". Property will be left empty.", (Throwable)exc);
            }
        }
    }

    private boolean hasPlaceholders(Object deployableValue, PropertyDescriptor deployablePropDesc) {
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: 
            case DATE: 
            case CI: 
            case SET_OF_CI: 
            case LIST_OF_CI: {
                break;
            }
            case STRING: {
                return MustachePlaceholderScanner.hasPlaceholders((String)((String)deployableValue));
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                for (String s : (Collection)deployableValue) {
                    if (!MustachePlaceholderScanner.hasPlaceholders((String)s)) continue;
                    return true;
                }
                break;
            }
            case MAP_STRING_STRING: {
                for (String s : ((Map)deployableValue).values()) {
                    if (!MustachePlaceholderScanner.hasPlaceholders((String)s)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property type: " + deployablePropDesc.getKind());
            }
        }
        return false;
    }

    private Object getExistingDeployedValue(EmbeddedDeployedContainer existingDeployed, String name) {
        return existingDeployed == null ? null : existingDeployed.getProperty(name);
    }

    private Object getExistingDeployableValue(EmbeddedDeployedContainer existingDeployed, String name) {
        if (existingDeployed == null || !existingDeployed.getDeployable().hasProperty(name)) {
            return null;
        }
        return existingDeployed.getDeployable().getProperty(name);
    }

    private void checkWhetherValueIsSecureAndPropertyIsPassword(Object value, PropertyDescriptor deployedDesc, Object deployablePropertyValue) throws DictionaryValueException {
        if (value instanceof EncryptedStringValue && !deployedDesc.isPassword()) {
            logger.warn("The deployable value [{}] resolved to an encrypted value, but property [{}] is not a password field.", deployablePropertyValue, (Object)deployedDesc.getFqn());
            throw new DictionaryValueException("The deployable value [%s] resolved to an encrypted value, but property [%s] is not a password field.", new Object[]{deployablePropertyValue, deployedDesc.getFqn()});
        }
    }

    private boolean isNullOrEmpty(Object value, PropertyDescriptor deployablePropDesc) {
        if (value == null) {
            return true;
        }
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: 
            case DATE: 
            case CI: 
            case STRING: {
                return Strings.isNullOrEmpty((String)value.toString());
            }
            case SET_OF_CI: 
            case LIST_OF_CI: 
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                return ((Collection)value).isEmpty();
            }
            case MAP_STRING_STRING: {
                return ((Map)value).isEmpty();
            }
        }
        throw new IllegalStateException("Unsupported property kind: " + deployablePropDesc.getKind() + " for property: " + deployablePropDesc.getFqn());
    }

    private void setDeployedFromDictionary(EmbeddedDeployedContainer deployed, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc, PropertyDescriptor deployablePropDesc) {
        if (dictionary.containsKey(deployedPropDesc.getFqn())) {
            Object value = dictionary.get(deployedPropDesc.getFqn());
            value = this.convertIfNeeded(value, deployablePropDesc, deployedPropDesc);
            deployedPropDesc.set((ConfigurationItem)deployed, value);
        }
    }

    private Object convertIfNeeded(Object valueToSet, PropertyDescriptor deployablePropDesc, PropertyDescriptor deployedPropDesc) {
        if (valueToSet == null) {
            return valueToSet;
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.CI) {
            return this.repository.read(valueToSet.toString());
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.SET_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.LIST_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (deployedPropDesc.getKind() == PropertyKind.STRING) {
            if (deployedPropDesc instanceof EncryptedStringValue && !deployedPropDesc.isPassword()) {
                logger.warn("Going to write a Encrypted value as plaintext in [{}], as it is not a password field.", (Object)deployedPropDesc);
            }
            return valueToSet.toString();
        }
        if (valueToSet instanceof StringValue) {
            return valueToSet.toString();
        }
        return valueToSet;
    }

    private Collection<String> splitValue(Object valueToSet) {
        Checks.checkArgument((valueToSet instanceof String || valueToSet instanceof StringValue ? 1 : 0) != 0, (String)"Should be String or StringValue to split.", (Object[])new Object[0]);
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings();
        return Lists.newArrayList((Iterable)splitter.split((CharSequence)valueToSet.toString()));
    }

    private boolean optionalKind(PropertyDescriptor deployablePropDesc, PropertyKind kind) {
        return deployablePropDesc == null || deployablePropDesc.getKind() == kind;
    }

    private Collection<ConfigurationItem> getCollectionOfCis(Object valueToSet) {
        ArrayList cis = Lists.newArrayList();
        for (String s : (Collection)valueToSet) {
            cis.add(this.repository.read(s));
        }
        return cis;
    }

    private void generateEmbeddeds(EmbeddedDeployedContainer<?, ?> deployed, final PropertyDescriptor deployedPropDesc, ConsolidatedDictionary dictionary) {
        ConfigurationItem deployable = deployed.getDeployable();
        String name = deployedPropDesc.getName();
        AbstractCollection embeddedDeployeds = deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
        PropertyDescriptor deployableProperty = deployable.getType().getDescriptor().getPropertyDescriptor(name);
        Collection embeddedDeployables = (Collection)deployableProperty.get(deployed.getDeployable());
        for (EmbeddedDeployable embeddedDeployable : embeddedDeployables) {
            List<Type> embeddedDeployedTypes = this.calculator.findAllMostSpecificDeployedTypesForDeployableAndContainerTypes(embeddedDeployable.getType(), deployed.getType());
            Collection filtered = Collections2.filter(embeddedDeployedTypes, (Predicate)new Predicate<Type>(){

                public boolean apply(Type input) {
                    return input.instanceOf(deployedPropDesc.getReferencedType());
                }
            });
            if (filtered.isEmpty()) {
                logger.info("Not found a matching EmbeddedDeployed type for [{}] and [{}]", (Object)embeddedDeployable.getType(), (Object)deployed.getType());
                continue;
            }
            if (filtered.size() > 1) {
                logger.error("Found more than 1 ({}) compatible EmbeddedDeployed type for [{}] and [{}]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
                throw new Checks.IncorrectArgumentException("Found more than 1 (%s) compatible EmbeddedDeployed type for [%s] and [%s]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
            }
            Type embeddedDeployedType = (Type)filtered.iterator().next();
            EmbeddedDeployed embeddedDeployed = (EmbeddedDeployed)embeddedDeployedType.getDescriptor().newInstance(IdGenerator.generateId(deployed, (String)embeddedDeployable.getId()));
            embeddedDeployed.setDeployable((ConfigurationItem)embeddedDeployable);
            embeddedDeployed.setContainer(deployed);
            if (MustachePlaceholderScanner.hasPlaceholders((String)embeddedDeployed.getName())) {
                try {
                    dictionary.resolveDeployedName((EmbeddedDeployedContainer)embeddedDeployed);
                }
                catch (DictionaryValueException e) {
                    throw new DeployedGenerator.IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", embeddedDeployable.getId());
                }
            }
            embeddedDeployeds.add(embeddedDeployed);
            this.setProperties((EmbeddedDeployedContainer)embeddedDeployed, null, dictionary);
        }
        deployedPropDesc.set(deployed, (Object)embeddedDeployeds);
    }

    private boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && propertyDescriptor.getKind() == PropertyKind.SET_OF_CI && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

