/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.inspection;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeployedInspectionHelper<C extends Container, D extends Deployed> {
    public static final String DISCOVER_SCRIPT_PROPERTY_NAME = "discoverScript";
    private Class<C> containerSuperClass;
    private Class<D> deployedSuperClass;
    private static Logger logger = LoggerFactory.getLogger(DeployedInspectionHelper.class);

    public DeployedInspectionHelper(Class<C> containerSuperClass, Class<D> deployedSuperClass) {
        this.containerSuperClass = containerSuperClass;
        this.deployedSuperClass = deployedSuperClass;
    }

    public void discoverDeployeds(C container, InspectionContext ctx) {
        this.discoverDeployeds(container, ctx, DescriptorRegistry.getSubtypes((Type)Type.valueOf(this.deployedSuperClass)));
    }

    public void discoverDeployeds(C container, InspectionContext ctx, Iterable<Type> types) {
        Multimap<Integer, Step> steps = this.newSortedKeyMultimapForSteps();
        Type containerT = container.getType();
        for (Type deployedT : types) {
            Descriptor deployedD = deployedT.getDescriptor();
            logger.debug("Checking whether type [{}] is not virtual", (Object)deployedT);
            if (deployedD.isVirtual()) continue;
            Type deployedContainerT = deployedD.getContainerType();
            Type targetContainerT = Type.valueOf(this.containerSuperClass);
            logger.debug("Checking whether type [{}] is instance of type [{}]", (Object)deployedContainerT, (Object)targetContainerT);
            if (!containerT.instanceOf(targetContainerT)) continue;
            logger.debug("Checking whether type [{}] has a discoveryScript property", (Object)deployedT);
            PropertyDescriptor discoveryScriptProperty = deployedD.getPropertyDescriptor(DISCOVER_SCRIPT_PROPERTY_NAME);
            if (discoveryScriptProperty == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a default value", (Object)deployedT);
            Object defaultValue = discoveryScriptProperty.getDefaultValue();
            if (defaultValue == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a string value", (Object)deployedD.getType());
            if (!(defaultValue instanceof String)) continue;
            String scriptName = (String)defaultValue;
            logger.debug("Adding inspection step using script {} for container {}", (Object)scriptName, container);
            HashMap varsCtx = Maps.newHashMap();
            varsCtx.put("container", container);
            Deployed prototype = (Deployed)deployedD.newInstance();
            varsCtx.put("prototype", prototype);
            Step step = this.createInspectionStep(container, prototype, scriptName, varsCtx, "Discover objects of type " + deployedT + " on " + container);
            int discoverOrder = 0;
            if (prototype.hasProperty("discoverOrder")) {
                discoverOrder = (Integer)prototype.getProperty("discoverOrder");
            }
            steps.put((Object)discoverOrder, (Object)step);
        }
        for (Step step : steps.values()) {
            ctx.addStep(step);
        }
    }

    protected abstract Step createInspectionStep(C var1, D var2, String var3, Map<String, Object> var4, String var5);

    private Multimap<Integer, Step> newSortedKeyMultimapForSteps() {
        return Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<Step>>(){

            public List<Step> get() {
                return Lists.newArrayList();
            }
        });
    }
}

