/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.python.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.python.apache.xerces.impl.dv.ValidationContext;
import org.python.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.python.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string2);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gMonthDay"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String string2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData dateTimeData = new AbstractDateTimeDV.DateTimeData(string2, this);
        int n = string2.length();
        dateTimeData.year = 2000;
        if (string2.charAt(0) != '-' || string2.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string2);
        }
        dateTimeData.month = this.parseInt(string2, 2, 4);
        int n2 = 4;
        if (string2.charAt(n2++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string2);
        }
        dateTimeData.day = this.parseInt(string2, n2, n2 + 2);
        if (7 < n) {
            if (!this.isNextCharUTCSign(string2, 7, n)) {
                throw new SchemaDateTimeException("Error in month parsing:" + string2);
            }
            this.getTimeZone(string2, dateTimeData, 7, n);
        }
        this.validateDateTime(dateTimeData);
        this.saveUnnormalized(dateTimeData);
        if (dateTimeData.utc != 0 && dateTimeData.utc != 90) {
            this.normalize(dateTimeData);
        }
        dateTimeData.position = 1;
        return dateTimeData;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData dateTimeData) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, dateTimeData.month, 2);
        stringBuffer.append('-');
        this.append(stringBuffer, dateTimeData.day, 2);
        this.append(stringBuffer, (char)dateTimeData.utc, 0);
        return stringBuffer.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData dateTimeData) {
        return this.factory.newXMLGregorianCalendar(Integer.MIN_VALUE, dateTimeData.unNormMonth, dateTimeData.unNormDay, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, dateTimeData.timezoneHr * 60 + dateTimeData.timezoneMin);
    }
}

