/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit38ConfigurationRoot
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit38ConfigurationRoot.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.8 upgrade -- Create new Configuration root node ***");
        try {
            this.createRoot(((RawRepositoryImpl)repository).getSession(), Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName());
            logger.info("*** Finished upgrade ***");
            return true;
        }
        catch (RepositoryException e) {
            throw new UpgradeException("", (Exception)((Object)e));
        }
    }

    private void createRoot(Session session, String rootNodeName) throws RepositoryException {
        Node node = session.getRootNode().addNode(rootNodeName);
        node.addMixin("deployit:configurationItem");
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        node.setProperty("$configuration.item.type", "internal." + Root.class.getSimpleName());
        node.setProperty("$lastModified", Calendar.getInstance());
        session.save();
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.8.0");
    }
}

