/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.spi.exception;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import java.util.Collection;
import java.util.List;

@HttpResponseCodeResult
public class DeployitException
extends RuntimeException {
    private final List<String> errors;
    private Object entity;

    public DeployitException() {
        this.errors = Lists.newArrayList();
    }

    public DeployitException(String message) {
        this.errors = Lists.newArrayList();
        this.errors.add(message);
    }

    public DeployitException(String messageTemplate, Object ... params) {
        this.errors = Lists.newArrayList((Object[])new String[]{String.format(messageTemplate, params)});
    }

    public DeployitException(Throwable cause, String messageTemplate, Object ... params) {
        super(cause);
        this.errors = Lists.newArrayList((Object[])new String[]{String.format(messageTemplate, params)});
    }

    public DeployitException(Throwable cause) {
        super(cause);
        this.errors = Lists.newArrayList();
    }

    public DeployitException(Object entity) {
        this.entity = entity;
        this.errors = Lists.newArrayList();
    }

    public void add(String messageTemplate, Object ... params) {
        this.errors.add(String.format(messageTemplate, params));
    }

    public void addAll(Collection<String> messages) {
        this.errors.addAll(messages);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return Joiner.on((String)"\n").join(this.errors);
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public Object getEntity() {
        return this.entity;
    }
}

