/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.xebialabs.deployit.DeployitConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeployitConfiguration {
    public static final String CONFIGURATION_FILENAME = "deployit.conf";
    public static final File DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf");
    private static final AtomicReference<DeployitConfig> CONFIG = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger(DeployitConfiguration.class);

    public static void load() {
        DeployitConfiguration.load(DEFAULT_CONFIGURATION_FILE);
    }

    public static void load(File file) {
        logger.debug("Loading Deployit configuration from {}", (Object)file.getAbsolutePath());
        CONFIG.compareAndSet(null, DeployitConfiguration.loadConfig(file));
    }

    public static boolean exists() {
        return DEFAULT_CONFIGURATION_FILE.exists();
    }

    public static DeployitConfig getInstance() {
        return CONFIG.get();
    }

    public static void writeConfiguration(DeployitConfig deployitConfig) {
        DeployitConfiguration.writeConfiguration(DEFAULT_CONFIGURATION_FILE, deployitConfig);
    }

    public static void readIntoConfiguration(DeployitConfig deployitConfig) {
        deployitConfig.load(DeployitConfiguration.readConfigurationFile(DEFAULT_CONFIGURATION_FILE));
    }

    static DeployitConfig loadConfig(File configFile) {
        if (configFile.exists()) {
            DeployitConfig deployitConfig = DeployitConfiguration.readConfiguration(configFile);
            if (!deployitConfig.isValid()) {
                throw new Error("Configuration " + configFile + " is not valid please run with -setup option.");
            }
            if (deployitConfig.isDirty()) {
                logger.info("Saving (dirty) configuration");
                DeployitConfiguration.writeConfiguration(configFile, deployitConfig);
            }
            return deployitConfig;
        }
        throw new Error("Configuration " + configFile + " does not exist, please run with -setup option before starting the server or command line interface.");
    }

    static DeployitConfig readConfiguration(File configFile) {
        DeployitConfig deployitConfig = new DeployitConfig();
        deployitConfig.load(DeployitConfiguration.readConfigurationFile(configFile));
        return deployitConfig;
    }

    static Properties readConfigurationFile(File configFile) {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = (FileInputStream)Files.newInputStreamSupplier((File)configFile).getInput();
            properties.load(inStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)inStream);
        return properties;
    }

    static void writeConfiguration(File configFile, DeployitConfig deployitConfig) {
        Properties properties = new Properties();
        deployitConfig.save(properties);
        FileOutputStream output = null;
        try {
            output = (FileOutputStream)Files.newOutputStreamSupplier((File)configFile).getOutput();
            properties.store(output, "Deployit configuration file.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }
}

