/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NAME_IS_OPERATOR = "NAME_IS";
    private static final String NAME_LIKE_OPERATOR = "NAME_LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private static final String CONTAINS_OPERATOR = "CONTAINS";
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(SearchParameters parameters) {
        this.parameters = parameters;
        this.joins = new StringBuilder();
        this.conditions = Lists.newArrayList();
        Checks.checkArgument(parameters.name == null || !parameters.name.contains("'"), "Name [%s] contains a single quote (')", parameters.name);
        Checks.checkArgument(parameters.parent == null || !parameters.parent.contains("'"), "Parent [%s] contains a single quote (')", parameters.parent);
    }

    public Query build(Session session) throws RepositoryException {
        this.createJoinsAndConditions();
        QueryManager qm = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        String q = this.constructQueryString();
        Query query = qm.createQuery(q, "JCR-SQL2");
        this.addBinds(valueFactory, query);
        this.addPagingInfo(query);
        logger.trace("JCR query built: {}", (Object)query.getStatement());
        return query;
    }

    private String constructQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ci.* FROM [deployit:configurationItem] AS ci");
        builder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            builder.append(" WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Collections2.transform(this.conditions, (Function)new Function<Condition, String>(){

                public String apply(Condition input) {
                    return input.build();
                }
            })));
        }
        builder.append(" ORDER BY NAME(ci)");
        logger.trace("Query string built: {}", (Object)builder.toString());
        return builder.toString();
    }

    private void addBinds(ValueFactory valueFactory, Query query) throws RepositoryException {
        for (Condition eachCondition : this.conditions) {
            if (eachCondition.parameter == null) continue;
            for (int i = 0; i < eachCondition.values.length; ++i) {
                Value v;
                Object eachValue = eachCondition.values[i];
                if (eachValue instanceof String) {
                    v = valueFactory.createValue((String)eachValue);
                } else if (eachValue instanceof Calendar) {
                    v = valueFactory.createValue((Calendar)eachValue);
                } else {
                    throw new IllegalArgumentException("Value of Condition is not a String or a Calendar but a " + eachValue.getClass().getName());
                }
                query.bindValue(eachCondition.parameter + i, v);
                logger.trace("Bound {} to {}", (Object)(eachCondition.parameter + i), (Object)v.getString());
            }
        }
    }

    void addPagingInfo(Query query) {
        if (this.parameters.resultsPerPage > 0L) {
            query.setLimit(this.parameters.resultsPerPage);
            query.setOffset(this.parameters.page * this.parameters.resultsPerPage);
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForName();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForDate();
        this.createConditionsForProperties();
        this.createConditionsForTextSearch();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (this.parameters.type != null) {
            ArrayList types = Lists.newArrayList();
            types.add(this.parameters.type.toString());
            for (Type subtype : DescriptorRegistry.getSubtypes((Type)this.parameters.type)) {
                types.add(subtype.toString());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, types.toArray(new String[types.size()])));
        }
    }

    private void createConditionForParent() {
        if (!Strings.nullToEmpty((String)this.parameters.parent).trim().isEmpty()) {
            String parent = Strings.nullToEmpty((String)this.parameters.parent);
            if (!parent.startsWith("/")) {
                parent = "/" + parent;
            }
            this.conditions.add(Condition.isChildNode(CI_SELECTOR_NAME, parent));
        }
    }

    private void createConditionForName() {
        if (!Strings.nullToEmpty((String)this.parameters.name).trim().isEmpty()) {
            if (this.parameters.name.contains("%")) {
                this.conditions.add(Condition.nameLike(CI_SELECTOR_NAME, this.parameters.name));
            } else {
                this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, this.parameters.name));
            }
        }
    }

    private void createConditionForDate() {
        if (this.parameters.before != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_before", "<=", this.parameters.before));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry<String, String> entry : this.parameters.properties.entrySet()) {
            this.createConditionForProperty(entry.getKey(), entry.getValue());
        }
    }

    private void createConditionForProperty(String propertyName, String propertyValue) {
        PropertyDescriptor propertyDescriptor;
        Descriptor descriptor;
        if (this.parameters.type != null && (descriptor = DescriptorRegistry.getDescriptor((Type)this.parameters.type)) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(propertyName)) != null) {
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                String selectorName = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + selectorName + " ON " + CI_SELECTOR_NAME + ".[" + propertyName + "] = " + selectorName + ".[jcr:uuid]");
                int lastSlash = propertyValue.lastIndexOf(47);
                Preconditions.checkArgument((lastSlash != -1 ? 1 : 0) != 0, (Object)(propertyValue + " is a ID but does not contain a slash (/)"));
                String parent = JcrPathHelper.getAbsolutePathFromId(propertyValue.substring(0, lastSlash));
                String name = propertyValue.substring(lastSlash + 1);
                this.conditions.add(Condition.isChildNode(selectorName, parent));
                this.conditions.add(Condition.nameIs(selectorName, name));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, propertyName, propertyName, propertyValue));
    }

    private void createConditionsForTextSearch() {
        int count = 0;
        for (Map.Entry<String, String> query : this.parameters.textSearchQueries.entrySet()) {
            this.conditions.add(Condition.textSearch(query.getKey(), query.getValue(), "textSearch" + count + "_"));
        }
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String NAME_IS_FORMAT = "NAME(%s) = '%s'";
        private static final String NAME_LIKE_FORMAT = "LOWER(NAME(%s)) LIKE '%s'";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";
        private static final String CONTAINS_FORMAT = "contains(%s.[%s], $%s)";
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";

        private Condition() {
        }

        String build() {
            StringBuilder conditionString = new StringBuilder();
            conditionString.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    conditionString.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_IS_OPERATOR)) {
                    conditionString.append(String.format(NAME_IS_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_LIKE_OPERATOR)) {
                    conditionString.append(String.format(NAME_LIKE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    conditionString.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.CONTAINS_OPERATOR)) {
                    conditionString.append(String.format(CONTAINS_FORMAT, this.selector, this.field, this.parameter + i));
                    continue;
                }
                conditionString.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            conditionString.append(")");
            return conditionString.toString();
        }

        static Condition match(String selector, String field, String parameter, String value) {
            boolean caseInsensitive;
            String operator;
            if (value.contains("%")) {
                operator = SearchQueryBuilder.LIKE_OPERATOR;
                caseInsensitive = true;
            } else {
                operator = SearchQueryBuilder.EQUALITY_OPERATOR;
                caseInsensitive = false;
            }
            return Condition.from(selector, field, parameter, operator, caseInsensitive, value);
        }

        static Condition nameIs(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_IS_OPERATOR, false, value);
        }

        static Condition nameLike(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_LIKE_OPERATOR, false, value.toLowerCase());
        }

        static Condition isChildNode(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.ISCHILDNODE_OPERATOR, false, value);
        }

        static Condition textSearch(String property, String textQuery, String parameterName) {
            return Condition.from(SearchQueryBuilder.CI_SELECTOR_NAME, property, parameterName, SearchQueryBuilder.CONTAINS_OPERATOR, false, textQuery);
        }

        static Condition from(String selector, String field, String parameter, String operator, Object value) {
            return Condition.from(selector, field, parameter, operator, false, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, boolean caseInsensitive, Object ... values) {
            Condition t = new Condition();
            t.selector = selector;
            t.field = field;
            t.parameter = parameter;
            t.operator = operator;
            t.caseInsensitive = caseInsensitive;
            t.values = values;
            return t;
        }
    }
}

