/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsFailSafeManager
extends FsDecoratingManager<FsManager> {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private volatile Shutdown shutdown;

    public FsFailSafeManager(@NonNull FsManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver) {
        FsController<?> controller = this.delegate.getController(mountPoint, driver);
        if (null == this.shutdown) {
            FsFailSafeManager fsFailSafeManager = this;
            synchronized (fsFailSafeManager) {
                Shutdown shutdown = this.shutdown;
                if (null == shutdown) {
                    shutdown = new Shutdown(new Sync(this.delegate));
                    RUNTIME.addShutdownHook(shutdown);
                    this.shutdown = shutdown;
                }
            }
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super IOException, X> handler) throws X {
        if (null != this.shutdown) {
            FsFailSafeManager fsFailSafeManager = this;
            synchronized (fsFailSafeManager) {
                Shutdown shutdown = this.shutdown;
                if (null != shutdown) {
                    this.shutdown = null;
                    RUNTIME.removeShutdownHook(shutdown);
                }
            }
        }
        this.delegate.sync(options, handler);
    }

    private static class Sync
    implements Runnable {
        private final FsManager manager;

        Sync(FsManager manager) {
            assert (null != manager);
            this.manager = manager;
        }

        @Override
        public void run() {
            try {
                this.manager.sync(FsManager.UMOUNT);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class Shutdown
    extends Thread {
        Shutdown(Runnable runnable) {
            super(runnable, "TrueZIP FileSystemManager Shutdown Hook");
            super.setPriority(10);
        }
    }
}

