package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

import java.util.Collection;
import java.util.HashMap;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;

public class DefaultDeploymentPlanningContext implements DeploymentPlanningContext {

    private final Plans.InterleavedPlanBuilder planningResult;
    private final HashMap<String, Object> attributes = newHashMap();

    public DefaultDeploymentPlanningContext(Plans.InterleavedPlanBuilder planningResult) {
        this.planningResult = planningResult;
    }

    @Override
    public void addStep(DeploymentStep step) {
        planningResult.withStep(step);
    }

    @Override
    public void addSteps(DeploymentStep... steps) {
        planningResult.withSteps(steps);
    }

    @Override
    public void addSteps(Collection<DeploymentStep> steps) {
        planningResult.withSteps(newArrayList(steps));
    }

    @Override
    public Object getAttribute(String param) {
        return attributes.get(param);
    }

    @Override
    public void setAttribute(String param, Object value) {
        attributes.put(param, value);
    }

}
