package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.*;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Iterables.transform;
import static com.google.common.collect.Lists.newArrayList;

@Orchestrator.Metadata(name = "container-by-container-serial")
public class ContainerByContainerOrchestrator implements Orchestrator {
	@Override
	public Plan orchestrate(DeltaSpecification specification) {
		List<Delta> deltas = specification.getDeltas();
		Function<Delta, Container> deltaToContainer = new Function<Delta, Container>() {
			public Container apply(Delta input) {
				return getDeployed(input).getContainer();
			}
		};
		Function<Collection<Delta>, Plan> deltasToPlan = new Function<Collection<Delta>, Plan>() {
			public Plan apply(Collection<Delta> input) {
				return Plans.interleaved(newArrayList(input));
			}
		};
		return Plans.serial(newArrayList(transform(Multimaps.index(deltas, deltaToContainer).asMap().values(), deltasToPlan)));
	}

	private Deployed<?, ?> getDeployed(Delta input) {
		return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
	}
}
