/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DefaultDeploymentPlanningContext;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.InterleavedPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.ParallelPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.execution.SerialPlan;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import com.xebialabs.deployit.server.api.orchestrator.OrchestratorRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DeploymentPlanner
implements Planner {
    private Set<Method> contributors;
    private ListMultimap<Operation, Method> typeContributors;
    private List<Method> preProcessors;
    private List<Method> postProcessors;
    private ReadOnlyRepository repository;

    private DeploymentPlanner() {
    }

    @Override
    public Plan plan(DeltaSpecification deltaSpecification) {
        Plan plan = this.orchestrate(deltaSpecification);
        Plan plan2 = this.preProcessPlan(deltaSpecification);
        Plan plan3 = this.postProcessPlan(deltaSpecification);
        plan = this.resolvePlan(plan, deltaSpecification);
        return Plans.serial((Plan[])new Plan[]{plan2, plan, plan3});
    }

    private Plan postProcessPlan(DeltaSpecification deltaSpecification) {
        return this.processPlan(deltaSpecification, this.postProcessors);
    }

    private Plan preProcessPlan(DeltaSpecification deltaSpecification) {
        return this.processPlan(deltaSpecification, this.preProcessors);
    }

    private Plan processPlan(DeltaSpecification deltaSpecification, List<Method> list) {
        Plans.InterleavedPlanBuilder interleavedPlanBuilder = Plans.newInterleavedPlan((InterleavedPlan)Plans.interleaved((Delta[])new Delta[0]));
        for (Method method : list) {
            try {
                Object obj = method.getDeclaringClass().newInstance();
                this.addResultingStepToBuilder(method.invoke(obj, deltaSpecification), interleavedPlanBuilder, method);
            }
            catch (InstantiationException instantiationException) {
                throw new PlannerException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PlannerException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handleInvocationTargetException(invocationTargetException);
            }
        }
        return interleavedPlanBuilder.build();
    }

    private Plan resolvePlan(Plan plan, DeltaSpecification deltaSpecification) {
        if (plan instanceof ParallelPlan) {
            return this.resolveParallelPlan((ParallelPlan)plan, deltaSpecification);
        }
        if (plan instanceof SerialPlan) {
            return this.resolveSerialPlan((SerialPlan)plan, deltaSpecification);
        }
        Plans.InterleavedPlanBuilder interleavedPlanBuilder = Plans.newInterleavedPlan((InterleavedPlan)((InterleavedPlan)plan));
        this.orderedResolution((InterleavedPlan)plan, interleavedPlanBuilder, deltaSpecification);
        return interleavedPlanBuilder.build();
    }

    private Plan resolveSerialPlan(SerialPlan serialPlan, DeltaSpecification deltaSpecification) {
        return Plans.serial(this.resolvePlans(serialPlan.getPlans(), deltaSpecification));
    }

    private Plan resolveParallelPlan(ParallelPlan parallelPlan, DeltaSpecification deltaSpecification) {
        return Plans.parallel(this.resolvePlans(parallelPlan.getPlans(), deltaSpecification));
    }

    private List<Plan> resolvePlans(List<Plan> list, DeltaSpecification deltaSpecification) {
        ArrayList arrayList = Lists.newArrayList();
        for (Plan plan : list) {
            arrayList.add(this.resolvePlan(plan, deltaSpecification));
        }
        return arrayList;
    }

    private Plan orchestrate(DeltaSpecification deltaSpecification) {
        String string = deltaSpecification.getDeployedApplication().getOrchestrator();
        Orchestrator orchestrator = OrchestratorRegistry.getOrchestrator((String)string);
        Preconditions.checkNotNull((Object)orchestrator, (String)"Could not find a registered orchestrator with name [%s]", (Object[])new Object[]{string});
        return orchestrator.orchestrate(deltaSpecification);
    }

    private void orderedResolution(InterleavedPlan interleavedPlan, Plans.InterleavedPlanBuilder interleavedPlanBuilder, DeltaSpecification deltaSpecification) {
        DefaultDeploymentPlanningContext defaultDeploymentPlanningContext = new DefaultDeploymentPlanningContext(interleavedPlanBuilder, deltaSpecification.getDeployedApplication(), this.repository);
        this.callTypeContributors(this.typeContributors, interleavedPlan, interleavedPlanBuilder, defaultDeploymentPlanningContext);
        this.callContributors(this.contributors, interleavedPlan, interleavedPlanBuilder, defaultDeploymentPlanningContext);
    }

    private void callTypeContributors(ListMultimap<Operation, Method> listMultimap, InterleavedPlan interleavedPlan, Plans.InterleavedPlanBuilder interleavedPlanBuilder, DeploymentPlanningContext deploymentPlanningContext) {
        if (listMultimap == null) {
            return;
        }
        for (Delta delta : interleavedPlan.getDeltas()) {
            List list = listMultimap.get((Object)delta.getOperation());
            Deployed<?, ?> deployed = this.getActiveDeployed(delta);
            for (Method method : list) {
                Type type = Type.valueOf(method.getDeclaringClass());
                if (type.equals((Object)deployed.getType())) {
                    this.invokeTypeContributer(deploymentPlanningContext, delta, method);
                    continue;
                }
                Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
                if (!descriptor.isAssignableTo(type)) continue;
                this.invokeTypeContributer(deploymentPlanningContext, delta, method);
            }
        }
    }

    private void callContributors(Set<Method> set, InterleavedPlan interleavedPlan, Plans.InterleavedPlanBuilder interleavedPlanBuilder, DeploymentPlanningContext deploymentPlanningContext) {
        if (set == null) {
            return;
        }
        Deltas deltas = new Deltas(interleavedPlan.getDeltas());
        for (Method method : set) {
            try {
                Object obj = method.getDeclaringClass().newInstance();
                method.invoke(obj, deltas, deploymentPlanningContext);
            }
            catch (InstantiationException instantiationException) {
                throw new PlannerException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PlannerException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handleInvocationTargetException(invocationTargetException);
            }
        }
    }

    private Deployed<?, ?> getActiveDeployed(Delta delta) {
        if (delta.getOperation() == Operation.DESTROY) {
            return delta.getPrevious();
        }
        return delta.getDeployed();
    }

    private void invokeTypeContributer(DeploymentPlanningContext deploymentPlanningContext, Delta delta, Method method) {
        try {
            if (method.getParameterTypes().length == 2) {
                method.invoke(this.getActiveDeployed(delta), deploymentPlanningContext, delta);
            } else {
                method.invoke(this.getActiveDeployed(delta), deploymentPlanningContext);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PlannerException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
    }

    private void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable != null) {
            throw new PlannerException(throwable);
        }
        throw new PlannerException(invocationTargetException);
    }

    private void addResultingStepToBuilder(Object object, Plans.InterleavedPlanBuilder interleavedPlanBuilder, Method method) {
        if (object == null) {
            return;
        }
        if (object instanceof DeploymentStep) {
            interleavedPlanBuilder.withStep((DeploymentStep)object);
        } else if (object instanceof List) {
            interleavedPlanBuilder.withSteps((List)object);
        } else {
            throw new PlannerException("Result of call of %s is not of type Step of List<Step>.", method);
        }
    }

    public static class PlannerException
    extends RuntimeException {
        public PlannerException() {
        }

        public PlannerException(String string) {
            super(string);
        }

        public PlannerException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }

        public PlannerException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PlannerException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class DeploymentPlannerBuilder {
        private DeploymentPlanner planner = new DeploymentPlanner();

        public DeploymentPlannerBuilder typeContributors(ListMultimap<Operation, Method> listMultimap) {
            this.planner.typeContributors = listMultimap;
            return this;
        }

        public DeploymentPlannerBuilder contributors(Set<Method> set) {
            this.planner.contributors = set;
            return this;
        }

        public DeploymentPlannerBuilder preProcessors(List<Method> list) {
            this.planner.preProcessors = list;
            return this;
        }

        public DeploymentPlannerBuilder postProcessors(List<Method> list) {
            this.planner.postProcessors = list;
            return this;
        }

        public DeploymentPlannerBuilder repository(ReadOnlyRepository readOnlyRepository) {
            this.planner.repository = readOnlyRepository;
            return this;
        }

        public DeploymentPlanner build() {
            return this.planner;
        }
    }
}

