/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inspector {
    private Logger logger = LoggerFactory.getLogger(Inspector.class);

    public List<ConfigurationItem> inspect(ConfigurationItem item, ExecutionContext originalContext) {
        InspectionContext ctx = new InspectionContext(originalContext);
        return this.doInspect(item, ctx);
    }

    public List<ConfigurationItem> inspect(ConfigurationItem item, Map<String, Object> taskAttributes) {
        InspectionContext ctx = new InspectionContext(taskAttributes);
        return this.doInspect(item, ctx);
    }

    private List<ConfigurationItem> doInspect(ConfigurationItem item, InspectionContext ctx) {
        Step step;
        this.inspectConfigurationItem(item, ctx);
        while ((step = ctx.getNextStep()) != null) {
            Step.Result result;
            this.logger.debug("Invoking inspection step: {}", (Object)step.getDescription());
            try {
                ctx.startStepExecution(step);
                result = step.execute((ExecutionContext)ctx);
            }
            catch (Exception exc) {
                throw new RuntimeException("Step failed: " + step.getDescription(), exc);
            }
            if (result == Step.Result.Fail) {
                throw new RuntimeException("Step failed: " + step.getDescription());
            }
            this.inspectNewDiscoveredConfigurationItems(ctx);
        }
        return ctx.getInspected();
    }

    private void inspectNewDiscoveredConfigurationItems(InspectionContext context) {
        for (ConfigurationItem configurationItem : Lists.newArrayList(context.getDiscovered())) {
            this.inspectConfigurationItem(configurationItem, context);
        }
    }

    private void inspectConfigurationItem(ConfigurationItem item, InspectionContext context) {
        this.checkRequiredDiscoveryProperties(item);
        Method inspectMethod = this.findInspectMethod(item);
        if (inspectMethod != null) {
            try {
                this.logger.debug("Invoking @Inspect method on {}", (Object)item);
                inspectMethod.invoke((Object)item, context);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error invoking @Inspect method on " + item, e);
            }
        }
        context.inspected(item);
    }

    private void checkRequiredDiscoveryProperties(ConfigurationItem item) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object o;
            if (!propertyDescriptor.isInspectionProperty() || !propertyDescriptor.isRequiredForInspection() || (o = propertyDescriptor.get(item)) != null) continue;
            throw new IllegalArgumentException("Missing required property for discovery " + propertyDescriptor.getName());
        }
    }

    private Method findInspectMethod(ConfigurationItem item) {
        Method[] methods;
        for (Method method : methods = item.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Inspect.class)) continue;
            return method;
        }
        return null;
    }
}

