/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.deployment.orchestrator.DefaultOrchestrator;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import java.util.Collection;
import java.util.List;

@Orchestrator.Metadata(name="composite-package")
public class CompositePackageOrchestrator
implements Orchestrator {
    public Plan orchestrate(DeltaSpecification deltaSpecification) {
        Version version = deltaSpecification.getDeployedApplication().getVersion();
        if (version instanceof CompositePackage) {
            CompositePackage compositePackage = (CompositePackage)version;
            final List list = Lists.transform((List)compositePackage.getPackages(), (Function)new Function<Version, String>(){

                public String apply(Version version) {
                    return version.getId();
                }
            });
            final ImmutableListMultimap immutableListMultimap = Multimaps.index((Iterable)deltaSpecification.getDeltas(), (Function)new Function<Delta, String>(){

                public String apply(Delta delta) {
                    final String string = CompositePackageOrchestrator.this.getDeployed(delta).getDeployable().getId();
                    Collection collection = Collections2.filter((Collection)list, (Predicate)new Predicate<String>(){

                        public boolean apply(String string2) {
                            return string.startsWith(string2);
                        }
                    });
                    if (collection.isEmpty() || collection.size() > 1) {
                        throw new IllegalStateException(String.format("Found no or more than 1 DeploymentPackage (%s) which could have been the source of [%s]", collection, string));
                    }
                    return (String)Iterables.get((Iterable)collection, (int)0);
                }
            });
            return Plans.serial((List)Lists.transform((List)list, (Function)new Function<String, Plan>(){

                public Plan apply(String string) {
                    return Plans.interleaved((List)immutableListMultimap.get((Object)string));
                }
            }));
        }
        return new DefaultOrchestrator().orchestrate(deltaSpecification);
    }

    private Deployed<?, ?> getDeployed(Delta delta) {
        return delta.getDeployed() != null ? delta.getDeployed() : delta.getPrevious();
    }
}

