/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inspector {
    private Logger logger = LoggerFactory.getLogger(Inspector.class);

    public List<ConfigurationItem> inspect(ConfigurationItem configurationItem, ExecutionContext executionContext) {
        InspectionContext inspectionContext = new InspectionContext(executionContext);
        return this.doInspect(configurationItem, inspectionContext);
    }

    public List<ConfigurationItem> inspect(ConfigurationItem configurationItem, Map<String, Object> map) {
        InspectionContext inspectionContext = new InspectionContext(map);
        return this.doInspect(configurationItem, inspectionContext);
    }

    private List<ConfigurationItem> doInspect(ConfigurationItem configurationItem, InspectionContext inspectionContext) {
        Step step;
        this.inspectConfigurationItem(configurationItem, inspectionContext);
        while ((step = inspectionContext.getNextStep()) != null) {
            Step.Result result;
            this.logger.debug("Invoking inspection step: {}", (Object)step.getDescription());
            try {
                inspectionContext.startStepExecution(step);
                result = step.execute((ExecutionContext)inspectionContext);
            }
            catch (Exception exception) {
                String string = this.getLastMessageFromLogs(inspectionContext.getCapturedError());
                throw new RuntimeException(String.format("Step '%s' failed with error: %s", step.getDescription(), string));
            }
            if (result == Step.Result.Fail) {
                String string = this.getLastMessageFromLogs(inspectionContext.getCapturedError());
                throw new RuntimeException(String.format("Step '%s' failed with error: %s", step.getDescription(), string));
            }
            this.inspectNewDiscoveredConfigurationItems(inspectionContext);
        }
        return inspectionContext.getInspected();
    }

    private String getLastMessageFromLogs(List<String> list) {
        if (list.size() > 0) {
            ListIterator<String> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                String string = listIterator.previous();
                if (string == null || string.length() == 0) continue;
                return string;
            }
        }
        return "No log found!";
    }

    private void inspectNewDiscoveredConfigurationItems(InspectionContext inspectionContext) {
        for (ConfigurationItem configurationItem : Lists.newArrayList(inspectionContext.getDiscovered())) {
            this.inspectConfigurationItem(configurationItem, inspectionContext);
        }
    }

    private void inspectConfigurationItem(ConfigurationItem configurationItem, InspectionContext inspectionContext) {
        this.checkRequiredDiscoveryProperties(configurationItem);
        Method method = this.findInspectMethod(configurationItem);
        if (method != null) {
            try {
                this.logger.debug("Invoking @Inspect method on {}", (Object)configurationItem);
                method.invoke((Object)configurationItem, inspectionContext);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + configurationItem, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + configurationItem, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Error invoking @Inspect method on " + configurationItem, invocationTargetException);
            }
        }
        inspectionContext.inspected(configurationItem);
    }

    private void checkRequiredDiscoveryProperties(ConfigurationItem configurationItem) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object object;
            if (!propertyDescriptor.isInspectionProperty() || !propertyDescriptor.isRequiredForInspection() || (object = propertyDescriptor.get(configurationItem)) != null) continue;
            throw new IllegalArgumentException("Missing required property for discovery " + propertyDescriptor.getName());
        }
    }

    private Method findInspectMethod(ConfigurationItem configurationItem) {
        Method[] methodArray;
        for (Method method : methodArray = configurationItem.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Inspect.class)) continue;
            return method;
        }
        return null;
    }
}

