/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;

/**
 * A {@link ConfigurationItem} that can be used to specify that a certain package artifact or resource should be
 * targeted to a specific environment member
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Used to specify that a certain package artifact or resource should be targeted to a specific environment member")
public class Mapping extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true)
	private Serializable source;

	@ConfigurationItemProperty(required = true)
	private Serializable target;

	public Mapping() {
		// default constructor
	}

	public Mapping(Serializable source, Serializable target) {
		this.label = "Mapping from " + source + " to " + target;
		this.source = source;
		this.target = target;
	}

	public Serializable getSource() {
		return source;
	}

	public void setSource(Serializable source) {
		this.source = source;
	}

	public Serializable getTarget() {
		return target;
	}

	public void setTarget(Serializable target) {
		this.target = target;
	}

	public boolean isSimilar(Mapping that) {
		boolean sourcesAreSimilar = ConfigurationItemReflectionUtils.isSimilar(this.getSource(), that.getSource());
		boolean targetsAreSimilar = ConfigurationItemReflectionUtils.isSimilar(this.getTarget(), that.getTarget());
		return sourcesAreSimilar && targetsAreSimilar;
	}

	public boolean isIdentical(Mapping that) {
		boolean sourcesAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getSource(), that.getSource());
		boolean mappingsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this, that);
		boolean targetsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getTarget(), that.getTarget());
		return sourcesAreIdentical && mappingsAreIdentical && targetsAreIdentical;
	}

}
