/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.mapper.artifact;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.DeleteStep;
import com.xebialabs.deployit.steps.PlaceholderReplacingCopyStep;

/**
 * Mapper that maps {@link ConfigurationFiles} CI's to {@link Host hosts} with {@link ConfigurationFilesMapping} CI's.
 */
public class ConfigurationFilesToHostMapper extends StepGeneratingMapper<ConfigurationFiles, ConfigurationFilesMapping, Host> {

	public ConfigurationFilesToHostMapper(Change<Deployment> c) {
		super(c, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(ConfigurationFiles newSource, ConfigurationFilesMapping m, Host newTarget, List<Step> steps) {
		Map<String, String> propertyMap = listOfKVPairsToMap(m.getKeyValuePairs());
		steps.add(new PlaceholderReplacingCopyStep(Host.getLocalHost(), ((ConfigurationFiles) m.getSource()).getLocation(), (Host) m.getTarget(), m
				.getTargetDirectory(), true, propertyMap));
	}

	private Map<String, String> listOfKVPairsToMap(List<KeyValuePair> keyValuePairs) {
		Map<String, String> map = new HashMap<String, String>();
		if (keyValuePairs != null) {
			for (KeyValuePair pair : keyValuePairs) {
				map.put(pair.getKey(), pair.getValue());
			}
		}
		return map;
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(ConfigurationFiles oldSource, ConfigurationFilesMapping m, Host oldTarget, List<Step> steps) {
		steps.add(new DeleteStep((Host) m.getTarget(), m.getTargetDirectory()));
	}

}
