package com.xebialabs.deployit;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;

import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Base class for {@link ConfigurationItem configuration items} that provides convenient default implementations for {@link #getLabel()}, {@link #setLabel(String)},
 * {@link #hashCode()}, {@link #equals(Object)}, {@link #toString()}.
 */
@SuppressWarnings("serial")
@ConfigurationItem
public abstract class BaseConfigurationItem implements Serializable {

	@ConfigurationItemLabel
	protected String label;

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public int hashCode() {
		if (label == null) {
			return 0;
		} else {
			return label.hashCode();
		}
	}

	@Override
	public boolean equals(Object thatObject) {
		if (this == thatObject)
			return true;

		if (thatObject == null)
			return false;

		if (!(thatObject instanceof BaseConfigurationItem))
			return false;

		BaseConfigurationItem that = (BaseConfigurationItem) thatObject;
		return new EqualsBuilder().append(getLabel(), that.getLabel()).isEquals();
	}

	@Override
	public String toString() {
		return ExtendedStringUtils.getQuotedString(label);
	}

}
