package com.xebialabs.deployit;

import java.io.Serializable;

/**
 * A changes on the repository to either add, modify or delete a configuration item.
 * 
 * @param <T>
 *            the class of the configuration item being changed.
 */
public interface Change<T extends Serializable> {

	/**
	 * The class of the CI that is being changed.
	 * 
	 * @return the class object of the CI under change.
	 */
	Class<T> getConfigurationItemClass();

	/**
	 * Returns true iff this change is an addition
	 */
	boolean isAddition();

	/**
	 * Return true iff this change is a modication.
	 */
	boolean isModification();

	/**
	 * Returns true iff this change is a deletion.
	 */
	boolean isDeletion();

	/**
	 * Returns the configuration item as it was before the change.
	 * 
	 * @return the CI before the change or <tt>null</tt> if this change is an addition.
	 */
	T getOldRevision();

	/**
	 * Returns the configuration item as it will be after the change.
	 * 
	 * @return the CI after the change or <tt>null</tt> if this change is a deletion.
	 */
	T getNewRevision();

}
