package com.xebialabs.deployit;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies that this class is a configuration item.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ConfigurationItem {

	/**
	 * The description of this configuration item.
	 */
	String description() default "Description unavailable";

	/**
	 * The category of this configuration item, e.g. "Middleware" or
	 * "Deployments". This determines where the configuration item will appear
	 * in the navigation tree in the UI.
	 * <p>
	 * If no value is supplied, configuration items of this type will only show
	 * up when you select the "All" category in the user interface.
	 */
	String category() default "";

	/**
	 * Whether this configuration can be expanded in the navigation tree in the
	 * UI.
	 */
	boolean expandable() default false;

	/**
	 * The mapping types for which this configuration item can be a source. This
	 * configuration item can be the source for these types and their subtypes.
	 */
	// should be Class<? extends Mapping> but Mapping isn't part of the API
	Class<?>[] sourceForMappingTypes() default {};

	/**
	 * The mapping types for which this configuration item can be a target. This
	 * configuration item can be the target for these types and their subtypes.
	 */
	// should be Class<? extends Mapping> but Mapping isn't part of the API
	Class<?>[] targetForMappingTypes() default {};

}
