package com.xebialabs.deployit;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.ci.security.PermissionScheme;

/**
 * Specifies the field of a {@link ConfigurationItem} that is to be injected
 * with the {@link PermissionScheme}.
 * <p>
 * The field may not be <tt>final</tt> and there should not be more than one per
 * {@link ConfigurationItem} (including its superclasses).
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ConfigurationItemPermissionScheme {

}
