package com.xebialabs.deployit;

import java.util.Collection;

/**
 * Implements the logic to translate a {@link ChangePlan} into a collection of {@link ChangeResolution}s.
 */
public interface RunBook {

	/**
	 * Invoked by the Deployit core when the changes in a changeplan have been modified. The implementation of this interface should resolve the changes into a
	 * collection of {@link ChangeResolution}s.
	 * 
	 * @param changeplan
	 *            the changeplan to resolve
	 * 
	 * @return a collection of {@link ChangeResolution}s that represent what needs to be done to make the changes happen.
	 */
	Collection<ChangeResolution> resolve(ChangePlan changeplan);

}
