package com.xebialabs.deployit;

import java.io.Serializable;

/**
 * Atomic executable action which on execution results in actually modifying the real environment.
 */
public interface Step extends Serializable {

	/**
	 * Returns a description of what this step will really do on execution.
	 * 
	 * @return the description.
	 */
	String getDescription();

	/**
	 * @param ctx
	 *            Context info required to execute the step.
	 * @return execution successful or failed.
	 */
	boolean execute(StepExecutionContext ctx);

}
