package com.xebialabs.deployit;

/**
 * Defines a set of methods that a step uses to communicate with its execution engine, e.g. to write to the log file.
 */
public interface StepExecutionContext {

	/**
	 * Logs a line of output. If this step is executing a command, this would be the output that is sent to the {@link System#setOut(java.io.PrintStream)
	 * standard output stream}.
	 * 
	 * @param output
	 *            the log line to be written to a destination.
	 */
	void logOutput(String output);

	/**
	 * Logs a line of error output. If this step is executing a command, this would be the output that is sent to the {@link System#setErr(java.io.PrintStream)
	 * standard error stream}.
	 * 
	 * @param error
	 *            the error to be written to a destination.
	 */
	void logError(String error);

}
