package com.xebialabs.deployit;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;

/**
 * A {@link CommandExecutionCallbackHandler} that logs the output to a {@link StepExecutionContext}.
 */
public class StepExecutionContextCallbackHandler implements CommandExecutionCallbackHandler {

	private StepExecutionContext ctx;

	public StepExecutionContextCallbackHandler(StepExecutionContext ctx) {
		this.ctx = ctx;
	}

	public void handleOutputLine(String line) {
		ctx.logOutput(line);
	}

	public void handleErrorLine(String line) {
		ctx.logError(line);
	}

	public void handleOutput(char c) {
		// no-op
	}

}
