package com.xebialabs.deployit.ci;

import static com.google.common.base.Preconditions.checkNotNull;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * Represents a collection of middleware CI's that belong together.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A group where middleware CI's can be added, can serve as a target for a deployment.", category = "environments")
public class Environment extends BaseConfigurationItem {

	@ConfigurationItemProperty
	private Set<Serializable> members = new HashSet<Serializable>();

	public Set<Serializable> getMembers() {
		return members;
	}

	@SuppressWarnings("unchecked")
	public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
		Set<T> matchingMembers = new HashSet<T>();
		for (Serializable member : getMembers()) {
			if (classType.isInstance(member)) {
				matchingMembers.add((T) member);
			}
		}
		return matchingMembers;
	}

	public void setMembers(Set<Serializable> members) {
		this.members = members;
	}

	public void addMember(Serializable member) {
		members.add(checkNotNull(member));
	}

}
