package com.xebialabs.deployit.ci.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ConfigurationItem;

/**
 * Represents a directory of files.
 */
@SuppressWarnings("serial")
@ConfigurationItem
public abstract class Folder extends DeployableArtifact {

	public List<File> getFiles() {
		List<File> files = new ArrayList<File>();
		File folderLocation = new File(getLocation());
		if (folderLocation.exists() && folderLocation.isDirectory() && folderLocation.canRead()) {
			File[] allFiles = folderLocation.listFiles();
			if (allFiles != null && allFiles.length > 0) {
				for (int i = 0; i < allFiles.length; i++) {
					files.add(allFiles[i]);
				}
			}
		}
		return files;
	}

}
