package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;

/**
 * A mapping of a {@link ConfigurationFiles} configuration item to a {@link Host}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a ConfigurationFiles CI to a Host")
public class ConfigurationFilesMapping extends DeployableArtifactMapping {

	@ConfigurationItemProperty(required = true, description = "The directory on the target host to which the configuration is to be copied. Non-existent directories on the path will be created. Example: /data/petclinic/1.0/conf")
	private String targetDirectory;

	public ConfigurationFilesMapping() {
		// default constructor
	}

	public ConfigurationFilesMapping(Serializable source, Serializable target, String targetDirectory) {
		super(source, target);
		this.targetDirectory = targetDirectory;
	}

	public String getTargetDirectory() {
		return targetDirectory;
	}

	public void setTargetDirectory(String targetDirectory) {
		this.targetDirectory = targetDirectory;
	}

}
