package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.ci.mapping.Mapping;

/**
 * A mapping of a {@link DeployableArtifact} to any kind of middleware
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a DeployableArtifact to any kind of middleware")
public abstract class DeployableArtifactMapping extends Mapping {

	@ConfigurationItemProperty(required = true, description = "Values for placeholders in the deployable artifact that are to be replaced. The key is the placeholder name. Example: Key: DATABASE_USER, Value: testUser")
	private List<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();

	public DeployableArtifactMapping() {
	}

	public DeployableArtifactMapping(Serializable source, Serializable target) {
		super(source, target);
	}

	public List<KeyValuePair> getKeyValuePairs() {
		return keyValuePairs;
	}

	public void setKeyValuePairs(List<KeyValuePair> keyValuePairs) {
		this.keyValuePairs = keyValuePairs;
	}

	public void addKeyValuePair(KeyValuePair keyValuePair) {
		if (keyValuePairs == null) {
			keyValuePairs = new ArrayList<KeyValuePair>();
		}
		keyValuePairs.add(keyValuePair);
	}
}
