package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Ear;

/**
 * A mapping of an {@link Ear} to any kind of middleware.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of an Ear to any kind of middleware")
public class EarMapping extends DeployableArtifactMapping {

	@ConfigurationItemProperty
	private String virtualHost;

	public EarMapping() {
		this.virtualHost = "";
	}

	public EarMapping(Ear source, Serializable target, String virtualHost) {
		super(source, target);
		this.virtualHost = virtualHost;
	}

	public String getVirtualHost() {
		return virtualHost;
	}

	public void setVirtualHost(String virtualHost) {
		this.virtualHost = virtualHost;
	}

}
