package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem
public class LibrariesMapping extends DeployableArtifactMapping {
	@ConfigurationItemProperty(required = true, description = "The directory on the target host to which the library is to be copied. Non-existent directories on the path will be created. Example: /data/petclinic/1.0/conf")
	private String targetDirectory;

	public LibrariesMapping() {
		// default constructor
	}

	public LibrariesMapping(Serializable source, Serializable target, String targetDirectory) {
		super(source, target);
		this.targetDirectory = targetDirectory;
	}

	public String getTargetDirectory() {
		return targetDirectory;
	}

	public void setTargetDirectory(String targetDirectory) {
		this.targetDirectory = targetDirectory;
	}

}
