package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.StaticContent;
import com.xebialabs.deployit.ci.mapping.Mapping;

/**
 * A mapping of a {@link StaticContent} to any kind of middleware.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a StaticContent to any kind of middleware")
public class StaticContentMapping extends Mapping {

	@ConfigurationItemProperty(description = "The virtual host <hostname>:<portnumber> as used by the HTTP and application server. Example: www.xebialabs.com:80")
	private String virtualHost;

	public StaticContentMapping() {
		// default constructor
	}

	public StaticContentMapping(StaticContent source, Serializable target, String virtualHost) {
		super(source, target);
		this.virtualHost = virtualHost;
	}

	public String getVirtualHost() {
		return virtualHost;
	}

	public void setVirtualHost(String virtualHost) {
		this.virtualHost = virtualHost;
	}

}
