package com.xebialabs.deployit.ci.mapping;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A key/value pair.
 */
@SuppressWarnings("serial")
public class KeyValuePair implements Serializable {

	@ConfigurationItemProperty
	private String key;

	@ConfigurationItemProperty
	private String value;

	/**
	 * Creates an empty key/value pair.
	 */
	public KeyValuePair() {
	}

	/**
	 * Creates a key/value pair with the specified key and value.
	 * 
	 * @param key
	 *            the key
	 * @param value
	 *            the value
	 */
	public KeyValuePair(String key, String value) {
		this.key = key;
		this.value = value;
	}

	/**
	 * Gets the key
	 * 
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * Sets the key
	 * 
	 * @param key
	 *            the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Gets the value
	 * 
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Sets the value
	 * 
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return String.format("%s=%s", key, value);
	}

}
