package com.xebialabs.deployit.ci.security;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * An access control entry on a {@link PermissionScheme}.
 */
@SuppressWarnings("serial")
public class AccessControlEntry implements Serializable {

	@ConfigurationItemProperty(label = "Group name", description = "Name of the group ")
	private String groupName;

	@ConfigurationItemProperty
	private boolean canView;

	@ConfigurationItemProperty
	private boolean canModify;

	@ConfigurationItemProperty
	private boolean canRedeploy;

	public AccessControlEntry() {
		// no-op
	}

	public AccessControlEntry(String groupName, boolean view, boolean modify, boolean redeploy, boolean addtogroup) {
		this.groupName = groupName;
		this.canView = view;
		this.canModify = modify;
		this.canRedeploy = redeploy;
	}

	public static AccessControlEntry getNoPermissions(String groupName) {
		return new AccessControlEntry(groupName, false, false, false, false);
	}

	public static AccessControlEntry getAllPermissions(String groupName) {
		return new AccessControlEntry(groupName, true, true, true, true);
	}

	@Override
	public String toString() {
		StringBuffer b = new StringBuffer();
		b.append("[");
		b.append("groupname=");
		b.append(getGroupName());
		b.append(" canview=");
		b.append(canView ? "true" : "false");
		b.append(" canmodify=");
		b.append(canModify ? "true" : "false");
		b.append(" canredeploy=");
		b.append(canRedeploy ? "true" : "false");
		b.append(" canaddtogroup=");
		b.append("]");
		return b.toString();
	}

	public void merge(AccessControlEntry aclEntryToMerge) {
		canView = canView || aclEntryToMerge.isCanView();
		canModify = canModify || aclEntryToMerge.isCanModify();
		canRedeploy = canRedeploy || aclEntryToMerge.isCanRedeploy();
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public boolean isCanView() {
		return canView;
	}

	public void setCanView(boolean canView) {
		this.canView = canView;
	}

	public boolean isCanModify() {
		return canModify;
	}

	public void setCanModify(boolean canModify) {
		this.canModify = canModify;
	}

	public boolean isCanRedeploy() {
		return canRedeploy;
	}

	public void setCanRedeploy(boolean canRedeploy) {
		this.canRedeploy = canRedeploy;
	}
}
