package com.xebialabs.deployit.ci.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A permission scheme that is applied to any number of configuration items.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A permission scheme to apply to a configuration item.", category = "permission schemes")
public class PermissionScheme extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, description = "Access control entries.")
	private List<AccessControlEntry> accessControlEntries = new ArrayList<AccessControlEntry>();

	@ConfigurationItemProperty(required = false, description = "Allowed CI types.")
	private Set<String> allowedCiTypes = new HashSet<String>();

	public AccessControlEntry getApplicablePermissions(String username, Collection<String> groupNames) {
		AccessControlEntry mergedAclEntry = AccessControlEntry.getNoPermissions(username);
		for (AccessControlEntry each : getAccessControlEntries()) {
			if (groupNames.contains(each.getGroupName())) {
				mergedAclEntry.merge(each);
			}
		}
		return mergedAclEntry;
	}

	public List<AccessControlEntry> getAccessControlEntries() {
		return accessControlEntries;
	}

	public void setAccessControlEntries(List<AccessControlEntry> accessControlEntries) {
		if (accessControlEntries == null) {
			this.accessControlEntries = new ArrayList<AccessControlEntry>();
		} else {
			this.accessControlEntries = accessControlEntries;
		}
	}

	public Set<String> getAllowedCiTypes() {
		return allowedCiTypes;
	}

	public void setAllowedCiTypes(Set<String> allowedCiTypes) {
		this.allowedCiTypes = allowedCiTypes;
	}

}
