package com.xebialabs.deployit.exception;

import java.io.IOException;

/**
 * Unchecked version of {@link IOException}
 */
public class RuntimeIOException extends RuntimeException {

	private static final long serialVersionUID = -2317308313788736309L;

	/**
	 * Constructs a RuntimeIOException with a message.
	 * 
	 * @param message
	 *            the message
	 */
	public RuntimeIOException(String message) {
		super(message);
	}

	/**
	 * Constructs a RuntimeIOException with a message and a cause.
	 * 
	 * @param message
	 *            the message
	 * @param cause
	 *            the exception
	 */
	public RuntimeIOException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructs a RuntimeIOException with a cause.
	 * 
	 * @param cause
	 *            the original exception
	 */
	public RuntimeIOException(Throwable cause) {
		super(cause);
	}

}
