package com.xebialabs.deployit.hostsession;

/**
 * Handler for callbacks from the host session.
 */
public interface CommandExecutionCallbackHandler {

	/**
	 * Invoked when an executed command generates a character of output (stdout).
	 * 
	 * @param c
	 *            the character of output generated.
	 */
	void handleOutput(char c);

	/**
	 * Invoked when an executed command generated a line of output (stdout).
	 * 
	 * @param line
	 *            the line of output generated.
	 */
	void handleOutputLine(String line);

	/**
	 * Invoked when an executed command generated a line of error (stderr).
	 * 
	 * @param line
	 *            the line of output generated.
	 */
	void handleErrorLine(String line);

}
