package com.xebialabs.deployit.hostsession;

/**
 * Implementation of the {@link CommandExecutionCallbackHandler} interface that sends its output to {@link System#out}
 * and {@link System#err}.
 */
public class DebugCommandExecutionCallbackHandler implements CommandExecutionCallbackHandler {

	public void handleOutputLine(String line) {
		System.out.println(line);
	}

	public void handleErrorLine(String line) {
		System.err.println(line);
	}

	public void handleOutput(char c) {
		System.out.print(c);
		System.out.flush();
	}
}
