package com.xebialabs.deployit.hostsession.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;

/**
 * Checks the output of an executed command and gives canned responses to expected output.
 */
public class InputResponseHandler implements CommandExecutionCallbackHandler {

	private OutputStream os;
	private Map<String, String> inputResponse;
	private CommandExecutionCallbackHandler handler;
	private StringBuffer output = new StringBuffer();

	public InputResponseHandler(CommandExecutionCallbackHandler handler, OutputStream os, Map<String, String> inputResponse) {
		this.os = os;
		this.inputResponse = inputResponse;
		this.handler = handler;
	}

	public void handleErrorLine(String line) {
		handler.handleErrorLine(line);
	}

	public void handleOutput(char c) {
		output.append(c);
		String totalOutput = output.toString();

		for (String key : inputResponse.keySet()) {
			if (totalOutput.endsWith(key)) {
				String response = inputResponse.get(key);
				try {
					if (logger.isDebugEnabled()) {
						logger.debug("Sending response " + response);
					}
					os.write(response.getBytes());
					os.flush();
				} catch (IOException e) {
					logger.error(e.getMessage());
				}
			}
		}
	}

	public void handleOutputLine(String line) {
		handler.handleOutputLine(line);
	}

	private static Logger logger = Logger.getLogger(InputResponseHandler.class.getName());

}
