package com.xebialabs.deployit.hostsession.common;

import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;

/**
 * Runnable object that reads an {@link InputStream} an invokes a {@link CommandExecutionCallbackHandler} for every line read.
 */
public class OutputStreamToCallbackHandler implements Runnable {

	private InputStream in;

	private CommandExecutionCallbackHandler handler;

	public OutputStreamToCallbackHandler(InputStream in, CommandExecutionCallbackHandler handler) {
		this.in = in;
		this.handler = handler;
	}

	public void run() {
		if (handler == null) {
			return;
		}

		InputStreamReader reader = new InputStreamReader(in);
		try {
			int readInt = reader.read();
			StringBuffer lineBuffer = new StringBuffer();
			while (readInt > -1) {
				char c = (char) readInt;
				handler.handleOutput(c);
				if (c != '\r' && c != '\n') {
					// add any character but a CR or LF to the line buffer
					lineBuffer.append(c);
				}
				if (c == '\n') {
					handler.handleOutputLine(lineBuffer.toString());
					lineBuffer = new StringBuffer();
				}
				readInt = reader.read();
			}
		} catch (Exception e) {
			logger.error(e);
		} finally {
			try {
				reader.close();
			} catch (Exception e) {
			}
		}
	}

	private static Logger logger = Logger.getLogger(OutputStreamToCallbackHandler.class);
}
