package com.xebialabs.deployit.hostsession.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostFile;

/**
 * A local host file
 */
class LocalHostFile extends AbstractHostFile implements HostFile {

	private File file;

	public LocalHostFile(HostSession session, File file) {
		super(session);
		this.file = file;
	}

	public File getFile() {
		return file;
	}

	public String getPath() {
		return file.getPath();
	}

	public String getName() {
		return file.getName();
	}

	public String getParent() {
		return file.getParent();
	}

	public boolean exists() {
		return file.exists();
	}

	public boolean isDirectory() {
		return file.isDirectory();
	}

	public long length() throws RuntimeIOException {
		return file.length();
	}

	public boolean canRead() {
		return file.canRead();
	}

	public boolean canWrite() {
		return file.canWrite();
	}

	public boolean canExecute() {
		// FIXME: remove this method from the interface or find a different
		// implementation
		// return file.canExecute();
		return false;
	}

	public List<String> list() throws RuntimeIOException {
		String[] listArray = file.list();
		if (listArray == null) {
			return null;
		} else {
			return Arrays.asList(listArray);
		}
	}

	public void mkdir() throws RuntimeIOException {
		if (!file.mkdir()) {
			throw new RuntimeIOException("Cannot create directory " + file.getPath());
		}
	}

	public void mkdirs() throws RuntimeIOException {
		if (file.exists()) {
			return;
		}
		if (!file.mkdirs()) {
			throw new RuntimeIOException("Cannot create directory " + file.getPath() + " or one of its parent directories");
		}
	}

	public boolean delete() {
		if (file.exists()) {
			if (!file.delete()) {
				throw new RuntimeIOException("Cannot delete " + file.getPath());
			}
			return true;
		} else {
			return false;
		}
	}

	public InputStream get() throws RuntimeIOException {
		try {
			return new FileInputStream(file);
		} catch (FileNotFoundException exc) {
			throw new RuntimeIOException(exc);
		}
	}

	public OutputStream put(long length) throws RuntimeIOException {
		try {
			return new FileOutputStream(file);
		} catch (FileNotFoundException exc) {
			throw new RuntimeIOException(exc);
		}
	}

	public String toString() {
		return file.toString();
	}

}
