package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.common.AbstractHostFile;

/**
 * A file on a host connected through SSH.
 */
abstract class SshHostFile extends AbstractHostFile implements HostFile {

	protected SshHostSession sshHostSession;

	protected String remotePath;

	/**
	 * Constructs a SshHostFile
	 * 
	 * @param session
	 *            the session connected to the host
	 * @param remotePath
	 *            the path of the file on the host
	 */
	SshHostFile(SshHostSession session, String remotePath) {
		super(session);
		sshHostSession = session;
		this.remotePath = remotePath;
	}

	public String getPath() {
		return remotePath;
	}

	public String getName() {
		String fileSep = sshHostSession.getHostOperatingSystem().getFileSeparator();
		int lastFileSepPos = remotePath.lastIndexOf(fileSep);
		if (lastFileSepPos < 0) {
			return remotePath;
		} else {
			return remotePath.substring(lastFileSepPos + 1);
		}
	}

	public String getParent() {
		String fileSep = sshHostSession.getHostOperatingSystem().getFileSeparator();
		int lastFileSepPos = remotePath.lastIndexOf(fileSep);
		if (lastFileSepPos < 0 || remotePath.equals(fileSep)) {
			return "";
		} else if (lastFileSepPos == 0) {
			// the parent of something in the root directory is the root
			// directory itself.
			return fileSep;
		} else {
			return remotePath.substring(0, lastFileSepPos);
		}
	}

	public boolean delete() throws RuntimeIOException {
		if (!exists()) {
			return false;
		} else if (isDirectory()) {
			deleteDirectory();
			return true;
		} else {
			deleteFile();
			return true;
		}
	}

	protected abstract void deleteFile();

	protected abstract void deleteDirectory();

	public String toString() {
		return getPath() + " on " + sshHostSession;
	}

}
