package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;

/**
 * A session to a remote host using SSH w/ SCP.
 */
public class SshScpHostSession extends SshHostSession {

	/**
	 * Constructs an SshScpHostSession
	 * 
	 * @param os
	 *            the operating system of the host
	 * @param temporaryDirectoryPath
	 *            the path of the directory in which to store temporary files
	 * @param host
	 *            the hostname or IP adress of the host
	 * @param port
	 *            the port to connect to
	 * @param username
	 *            the username to connect with
	 * @param password
	 *            the password to connect with
	 */
	public SshScpHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password) {
		super(os, temporaryDirectoryPath, host, port, username, password);
		open();
	}

	@Override
	protected HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
		return new SshScpHostFile(this, hostPath);
	}

	public String toString() {
		return username + "@" + host + ":" + port + " (scp)";
	}

}
