package com.xebialabs.deployit.hostsession.ssh;

import org.apache.log4j.Logger;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;

/**
 * A session to a remote host using SSH w/ SFTP.
 */
public class SshSftpHostSession extends SshHostSession {

	private ChannelSftp sharedSftpChannel;

	/**
	 * Constructs an SshSftpHostSession
	 * 
	 * @param os
	 *            the operating system of the host
	 * @param temporaryDirectoryPath
	 *            the path of the directory in which to store temporary files
	 * @param host
	 *            the hostname or IP adress of the host
	 * @param port
	 *            the port to connect to
	 * @param username
	 *            the username to connect with
	 * @param password
	 *            the password to connect with
	 */
	public SshSftpHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password) {
		super(os, temporaryDirectoryPath, host, port, username, password);
		open();
	}

	@Override
	public HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
		return new SshSftpHostFile(this, hostPath);
	}

	@Override
	public void close() {
		super.close();

		if (sharedSftpChannel != null) {
			closeSftpChannel(sharedSftpChannel);
		}
	}

	protected ChannelSftp getSharedSftpChannel() throws JSchException {
		if (sharedSftpChannel == null) {
			sharedSftpChannel = openSftpChannel();
		}
		return sharedSftpChannel;
	}

	protected ChannelSftp openSftpChannel() throws JSchException {
		Channel channel = getSharedSession().openChannel("sftp");
		if (logger.isDebugEnabled())
			logger.debug("Opened SFTP channel to " + this);
		channel.connect();
		return (ChannelSftp) channel;
	}

	protected void closeSftpChannel(ChannelSftp sftpChannel) {
		if (sftpChannel != null) {
			sftpChannel.disconnect();
			if (logger.isDebugEnabled())
				logger.debug("Closed SFTP channel to " + this);
		}
	}

	public String toString() {
		return username + "@" + host + ":" + port + " (sftp)";
	}

	private Logger logger = Logger.getLogger(SshSftpHostSession.class);

}
